

'use strict';
{
  const globals = this;
  const django = globals.django || (globals.django = {});

  
  django.pluralidx = function(n) {
    const v = 0;
    if (typeof v === 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  /* gettext library */

  django.catalog = django.catalog || {};
  
  const newcatalog = {
    "'s tags": "\u7684\u6807\u7b7e",
    "(If left blank, owner will be admin)": "\uff08\u5982\u679c\u4e3a\u7a7a\uff0c\u62e5\u6709\u8005\u5c06\u4e3a\u7ba1\u7406\u5458\uff09",
    "(at least {passwordMinLength} characters and includes {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols)": "\uff08\u81f3\u5c11 {passwordMinLength} \u4e2a\u5b57\u7b26\u5e76\u5305\u542b\u4ee5\u4e0b\u4e2d\u7684 {passwordStrengthLevel} \u79cd\uff1a\u6570\u5b57\uff0c\u5927\u5199\u5b57\u6bcd\uff0c\u5c0f\u5199\u5b57\u6bcd\u548c\u5176\u4ed6\u7b26\u53f7\uff09",
    "(at least {placeholder} characters)": "\uff08\u81f3\u5c11 {placeholder} \u4e2a\u5b57\u7b26\uff09",
    "(current notification)": "\uff08\u5f53\u524d\u901a\u77e5\uff09",
    "(current version)": "(\u5f53\u524d\u7248\u672c)",
    "(deleted)": "\uff08\u5df2\u5220\u9664\uff09",
    "1 Year": "1\u5e74",
    "1 cell copied": "\u5df2\u590d\u5236 1 \u4e2a\u5355\u5143\u683c",
    "1 cell cut": "1 \u4e2a\u5355\u5143\u683c\u5df2\u526a\u5207",
    "1 filter": "1 \u4e2a\u8fc7\u6ee4\u6761\u4ef6",
    "1 hidden property": "1 \u4e2a\u9690\u85cf\u5c5e\u6027",
    "1 month ago": "1\u4e2a\u6708\u4e4b\u524d",
    "1 preset hidden property": "1 \u4e2a\u9884\u9690\u85cf\u5c5e\u6027",
    "1 record selected": "1 \u6761\u8bb0\u5f55\u5df2\u9009\u4e2d",
    "1 row is copied.": "\u5df2\u590d\u5236 1 \u884c\u3002",
    "1 sort": "1 \u4e2a\u6392\u5e8f",
    "1 week ago": "1\u5468\u4e4b\u524d",
    "3 days ago": "3\u5929\u4e4b\u524d",
    "30 Days": "30\u5929",
    "7 Days": "7\u5929",
    "A file is being uploaded. Are you sure you want to leave this page?": "\u6b63\u5728\u4e0a\u4f20\u4e00\u4e2a\u6587\u4ef6\u3002\u4f60\u786e\u5b9a\u8981\u79bb\u5f00\u8fd9\u5f53\u524d\u7f51\u9875\u5417?",
    "A file with the same name already exists in this folder.": "\u8be5\u76ee\u5f55\u4e0b\u6709\u540c\u540d\u6587\u4ef6\u3002",
    "API Token": "API Token",
    "API token is copied to the clipboard.": "API token \u5df2\u590d\u5236\u5230\u526a\u8d34\u677f\u3002",
    "About": "\u5173\u4e8e",
    "About Us": "\u5173\u4e8e\u6211\u4eec",
    "Abuse Content": "\u5185\u5bb9\u975e\u6cd5",
    "Abuse Reports": "\u4e3e\u62a5",
    "Abuse Type": "\u4e3e\u62a5\u7c7b\u578b",
    "Abuse report added": "\u4e3e\u62a5\u5df2\u6dfb\u52a0",
    "Accept": "\u63a5\u53d7",
    "Accepted": "\u5df2\u7ecf\u63a5\u53d7",
    "Accepted at": "\u63a5\u53d7\u65f6\u95f4",
    "Accepter": "\u63a5\u53d7\u8005",
    "Access Log": "\u8bbf\u95ee\u65e5\u5fd7",
    "Access scope": "\u8bbf\u95ee\u8303\u56f4",
    "Accurate to minute": "\u7cbe\u786e\u5230\u5206\u949f",
    "Action": "\u64cd\u4f5c",
    "Actions": "\u64cd\u4f5c",
    "Activate after registration": "\u6ce8\u518c\u540e\u6fc0\u6d3b",
    "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email": "\u7528\u6237\u6ce8\u518c\u540e\u7acb\u5373\u6fc0\u6d3b\u7528\u6237\u3002\u5982\u679c\u5173\u95ed\u6b64\u529f\u80fd\uff0c\u65b0\u6ce8\u518c\u7528\u6237\u9700\u8981\u901a\u8fc7\u7ba1\u7406\u5458\u6216\u8005\u6fc0\u6d3b\u90ae\u4ef6\u6765\u8fdb\u884c\u6fc0\u6d3b",
    "Activated": "\u5df2\u6fc0\u6d3b",
    "Activated Users": "\u6fc0\u6d3b\u7528\u6237\u6570",
    "Active": "\u6fc0\u6d3b",
    "Active Users": "\u6d3b\u8dc3\u7528\u6237",
    "Active users": "\u6d3b\u8dc3\u7528\u6237",
    "Activities": "\u6587\u4ef6\u6d3b\u52a8",
    "Add": "\u6dfb\u52a0",
    "Add Admin": "\u6dfb\u52a0\u7ba1\u7406\u5458",
    "Add Admins": "\u6dfb\u52a0\u7ba1\u7406\u5458",
    "Add Folder": "\u589e\u52a0\u76ee\u5f55",
    "Add Institution": "\u6dfb\u52a0\u673a\u6784",
    "Add Library": "\u6dfb\u52a0\u8d44\u6599\u5e93",
    "Add Member": "\u6dfb\u52a0\u6210\u5458",
    "Add Organization": "\u6dfb\u52a0\u56e2\u961f",
    "Add Terms and Conditions": "\u589e\u52a0\u8f6f\u4ef6\u4f7f\u7528\u6761\u6b3e",
    "Add User": "\u6dfb\u52a0\u7528\u6237",
    "Add Wiki": "\u6dfb\u52a0\u77e5\u8bc6\u5e93",
    "Add admin": "\u6dfb\u52a0\u7ba1\u7406\u5458",
    "Add auto expiration": "\u589e\u52a0\u81ea\u52a8\u8fc7\u671f",
    "Add child tags": "\u589e\u52a0\u5b50\u6807\u7b7e",
    "Add cover": "\u589e\u52a0\u5c01\u9762",
    "Add custom permission": "\u589e\u52a0\u81ea\u5b9a\u4e49\u6743\u9650",
    "Add department at": "\u6dfb\u52a0\u90e8\u95e8\u5230",
    "Add filter": "\u589e\u52a0\u8fc7\u6ee4\u6761\u4ef6",
    "Add group": "\u589e\u52a0\u7fa4\u7ec4",
    "Add group member": "\u589e\u52a0\u7fa4\u7ec4\u6210\u5458",
    "Add icon": "\u589e\u52a0\u56fe\u6807",
    "Add institution": "\u6dfb\u52a0\u673a\u6784",
    "Add members": "\u6dfb\u52a0\u6210\u5458",
    "Add new notification": "\u6dfb\u52a0\u65b0\u901a\u77e5",
    "Add option": "\u589e\u52a0\u9009\u9879",
    "Add page": "\u589e\u52a0\u9875\u9762",
    "Add page above": "\u5728\u4e0a\u65b9\u589e\u52a0\u9875\u9762",
    "Add page below": "\u5728\u4e0b\u65b9\u589e\u52a0\u9875\u9762",
    "Add page inside": "\u6dfb\u52a0\u5b50\u9875\u9762",
    "Add password protection": "\u589e\u52a0\u5bc6\u7801\u4fdd\u62a4",
    "Add permission": "\u589e\u52a0\u6743\u9650",
    "Add sort": "\u589e\u52a0\u6392\u5e8f",
    "Add sub-department": "\u589e\u52a0\u5b50\u90e8\u95e8",
    "Add tag": "\u589e\u52a0\u6807\u7b7e",
    "Add to group": "\u589e\u52a0\u5230\u7fa4\u7ec4",
    "Add user": "\u6dfb\u52a0\u7528\u6237",
    "Add view": "\u589e\u52a0\u89c6\u56fe",
    "Added": "\u6dfb\u52a0\u7684",
    "Added user {user}": "\u5df2\u6dfb\u52a0\u7528\u6237 {user}",
    "Admin": "\u7ba1\u7406",
    "Admin Login Logs": "\u7ba1\u7406\u5458\u767b\u5f55\u65e5\u5fd7",
    "Admin Logs": "\u7ba1\u7406\u5458\u65e5\u5fd7",
    "Admin Operation Logs": "\u7ba1\u7406\u5458\u64cd\u4f5c\u65e5\u5fd7",
    "Admin access": "\u53ef\u7ba1\u7406",
    "Admin updated": "\u7ba1\u7406\u5458\u5df2\u66f4\u65b0",
    "Admins": "\u7ba1\u7406\u5458",
    "Advanced": "\u9ad8\u7ea7",
    "After enable OCR, you can extract text from images or scanned PDFs.": "\u5f00\u542f OCR \u540e\uff0c\u4f60\u53ef\u4ee5\u4ece\u56fe\u7247\u6216\u626b\u63cf\u7684 PDF \u4e2d\u63d0\u53d6\u6587\u672c\u3002",
    "After enable extended properties for files, you can add different properties to files, like collaborators, file expiring time, file description. You can also create different views for files based extended properties.": "\u4e3a\u6587\u4ef6\u542f\u7528\u6269\u5c55\u5c5e\u6027\u540e\uff0c\u4f60\u53ef\u4ee5\u5411\u6587\u4ef6\u6dfb\u52a0\u4e0d\u540c\u7684\u5c5e\u6027\uff0c\u5982\u534f\u4f5c\u8005\u3001\u6587\u4ef6\u8fc7\u671f\u65f6\u95f4\u3001\u6587\u4ef6\u63cf\u8ff0\u3002\u4f60\u8fd8\u53ef\u4ee5\u57fa\u4e8e\u6587\u4ef6\u7684\u6269\u5c55\u7279\u6027\u521b\u5efa\u4e0d\u540c\u7684\u89c6\u56fe\u3002",
    "All": "\u5168\u90e8",
    "All Activities": "\u6240\u6709\u6d3b\u52a8",
    "All Groups": "\u6240\u6709\u7fa4\u7ec4",
    "All Notifications": "\u6240\u6709\u901a\u77e5",
    "All Public Links": "\u6240\u6709\u516c\u5f00\u94fe\u63a5",
    "All files uploaded": "\u6240\u6709\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6bd5",
    "All records loaded": "\u5168\u90e8\u8bb0\u5f55\u5df2\u52a0\u8f7d",
    "All tags": "\u5168\u90e8\u6807\u7b7e",
    "Allow new registrations": "\u5141\u8bb8\u65b0\u6ce8\u518c",
    "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.": "\u5141\u8bb8\u7528\u6237\u6ce8\u518c\u3002\u5982\u679c\u5173\u95ed\u6b64\u529f\u80fd\uff0c\u5c06\u7981\u6b62\u4efb\u4f55\u4eba\u8fdb\u884c\u6ce8\u518c\u3002",
    "Allow users to change library history settings": "\u5141\u8bb8\u7528\u6237\u66f4\u6539\u8d44\u6599\u5e93\u5386\u53f2\u8bbe\u7f6e",
    "Allow users to clean library trash": "\u5141\u8bb8\u7528\u6237\u6e05\u7406\u8d44\u6599\u5e93\u56de\u6536\u7ad9",
    "Allow users to create encrypted libraries": "\u5141\u8bb8\u7528\u6237\u521b\u5efa\u52a0\u5bc6\u8d44\u6599\u5e93",
    "An integer that is greater than 0 or equal to -2.": "-2 \u6216\u5927\u4e8e 0 \u7684\u6574\u6570\u3002",
    "An integer that is greater than or equal to 0.": "\u5927\u4e8e\u7b49\u4e8e 0 \u7684\u6574\u6570\u3002",
    "An internal link is a link to a file or folder that can be accessed by users with read permission to the file or folder.": "\u5185\u90e8\u94fe\u63a5\u662f\u6307\u5411\u6587\u4ef6\u6216\u76ee\u5f55\u7684\u94fe\u63a5\uff0c\u53ea\u6709\u5bf9\u8be5\u6587\u4ef6\u6216\u76ee\u5f55\u6709\u8bbf\u95ee\u6743\u9650\u7684\u4eba\u53ef\u4ee5\u8bbf\u95ee\u3002",
    "And": "\u5e76\u4e14",
    "Anonymous User": "\u533f\u540d\u7528\u6237",
    "Another property has this property type": "\u53e6\u4e00\u4e2a\u5c5e\u6027\u5177\u6709\u6b64\u5c5e\u6027\u7c7b\u578b",
    "Another user is editing this file!": "\u5176\u4ed6\u7528\u6237\u5728\u7f16\u8f91\u8fd9\u4e2a\u6587\u4ef6\uff01",
    "Anyone with the link": "\u4efb\u4f55\u83b7\u5f97\u94fe\u63a5\u7684\u4eba",
    "App Name": "APP \u540d\u79f0",
    "Are you sure to change group {placeholder} to department ?": "\u4f60\u786e\u5b9a\u8981\u5c06\u7fa4\u7ec4 {placeholder}  \u66f4\u6539\u4e3a\u90e8\u95e8\u5417\uff1f",
    "Are you sure to delete": "\u786e\u5b9a\u8981\u5220\u9664",
    "Are you sure to delete ": "\u4f60\u786e\u5b9a\u8981\u5220\u9664",
    "Are you sure to revoke access of user {placeholder} ?": "\u4f60\u786e\u5b9a\u8981\u64a4\u6d88\u7528\u6237 {placeholder}\u7684\u8bbf\u95ee\u6743\u9650\u5417\uff1f",
    "Are you sure you want to clean invalid share links?": "\u786e\u5b9a\u8981\u6e05\u9664\u65e0\u6548\u7684\u5171\u4eab\u94fe\u63a5\u5417\uff1f",
    "Are you sure you want to clean invalid upload links?": "\u786e\u5b9a\u8981\u6e05\u9664\u65e0\u6548\u7684\u4e0a\u4f20\u94fe\u63a5\u5417\uff1f",
    "Are you sure you want to clear trash?": "\u786e\u5b9a\u8981\u6e05\u7a7a\u56de\u6536\u7ad9\u5417\uff1f",
    "Are you sure you want to delete": "\u4f60\u786e\u5b9a\u8981\u5220\u9664",
    "Are you sure you want to delete %s ?": "\u786e\u5b9a\u8981\u5220\u9664 %s \u5417\uff1f",
    "Are you sure you want to delete WebDAV password?": "\u786e\u5b9a\u8981\u5220\u9664 WebDAV \u5bc6\u7801\u5417\uff1f",
    "Are you sure you want to delete Wiki": "\u4f60\u786e\u5b9a\u8981\u5220\u9664\u77e5\u8bc6\u5e93\u5417",
    "Are you sure you want to delete the notification ?": "\u786e\u5b9a\u8981\u5220\u9664\u8be5\u901a\u77e5\u5417\uff1f",
    "Are you sure you want to delete the selected share link(s) ?": "\u786e\u5b9a\u8981\u5220\u9664\u52fe\u9009\u7684\u5171\u4eab\u94fe\u63a5\u5417\uff1f",
    "Are you sure you want to delete the selected upload link(s) ?": "\u4f60\u786e\u5b9a\u8981\u5220\u9664\u6240\u9009\u7684\u4e0a\u4f20\u94fe\u63a5\u5417\uff1f",
    "Are you sure you want to delete the selected user(s) ?": "\u786e\u5b9a\u8981\u5220\u9664\u9009\u4e2d\u7684\u7528\u6237\u5417\uff1f",
    "Are you sure you want to delete the share link?": "\u786e\u5b9a\u5220\u9664\u8be5\u5171\u4eab\u94fe\u63a5\u5417\uff1f",
    "Are you sure you want to delete this option?": "\u4f60\u786e\u5b9a\u8981\u5220\u9664\u8fd9\u4e2a\u9009\u9879\uff1f",
    "Are you sure you want to delete this page?": "\u786e\u5b9a\u8981\u5220\u9664\u8be5\u9875\u9762\uff1f",
    "Are you sure you want to delete {placeholder} ?": "\u786e\u5b9a\u8981\u5220\u9664 {placeholder} \u5417\uff1f",
    "Are you sure you want to delete {placeholder} completely?": "\u786e\u5b9a\u8981\u5f7b\u5e95\u5220\u9664 {placeholder} \u5417\uff1f",
    "Are you sure you want to disconnect?": "\u4f60\u786e\u5b9a\u8981\u65ad\u5f00\u8fde\u63a5\u5417\uff1f",
    "Are you sure you want to leave share Wiki": "\u4f60\u786e\u5b9a\u8981\u79bb\u5f00\u5171\u4eab\u77e5\u8bc6\u5e93\u5417",
    "Are you sure you want to remove {placeholder} ?": "\u786e\u5b9a\u8981\u79fb\u9664 {placeholder} \u5417\uff1f",
    "Are you sure you want to reset the password of {placeholder} ?": "\u786e\u5b9a\u8981\u91cd\u7f6e {placeholder} \u7684\u5bc6\u7801\u5417\uff1f",
    "Are you sure you want to restore this library?": "\u786e\u5b9a\u8981\u8fd8\u539f\u8be5\u8d44\u6599\u5e93\uff1f",
    "Are you sure you want to restore {placeholder}?": "\u786e\u5b9a\u8981\u6062\u590d {placeholder} \u5417\uff1f",
    "Are you sure you want to revoke the admin permission of {placeholder} ?": "\u786e\u5b9a\u8981\u64a4\u9500 {placeholder} \u7684\u7ba1\u7406\u6743\u9650\u5417\uff1f",
    "Are you sure you want to set {placeholder} as Admin?": "\u786e\u5b9a\u8981\u5c06 {placeholder} \u8bbe\u4e3a\u7ba1\u7406\u5458\uff1f",
    "Are you sure you want to set {user_placeholder} inactive?": "\u786e\u5b9a\u8981\u5c06 {user_placeholder} \u8bbe\u7f6e\u4e3a\u201c\u672a\u6fc0\u6d3b\u201d\u72b6\u6001?",
    "Are you sure you want to unlink this device?": "\u786e\u5b9a\u8981\u65ad\u5f00\u6b64\u8bbe\u5907\u7684\u8fde\u63a5\u5417\uff1f",
    "Are you sure you want to unpublish Wiki": "\u4f60\u786e\u5b9a\u8981\u53d6\u6d88\u53d1\u5e03\u77e5\u8bc6\u5e93\u5417",
    "Are you sure you want to unshare {placeholder} ?": "\u786e\u5b9a\u8981\u53d6\u6d88\u5171\u4eab {placeholder} \u5417\uff1f",
    "At server": "\u6240\u5728\u670d\u52a1\u5668",
    "Audio": "\u97f3\u9891",
    "Audit Admin": "\u5ba1\u8ba1\u7ba1\u7406\u5458",
    "Auth Token created": "Auth Token \u5df2\u521b\u5efa",
    "Auth Token deleted": "Auth Token \u5df2\u5220\u9664",
    "Authenticated emails": "\u9a8c\u8bc1\u7684\u90ae\u7bb1",
    "Authenticated users": "\u9a8c\u8bc1\u7684\u7528\u6237",
    "Auto deletion": "\u81ea\u52a8\u5220\u9664",
    "Automatically delete files that are not modified within certain days:": "\u81ea\u52a8\u5220\u9664\u5728\u4ee5\u4e0b\u5929\u6570\u5185\u672a\u4fee\u6539\u7684\u6587\u4ef6\uff1a",
    "Avatar": "\u5934\u50cf",
    "Avatar updated": "\u5934\u50cf\u5df2\u66f4\u65b0",
    "Avatar:": "\u5934\u50cf\uff1a",
    "Back": "\u8fd4\u56de",
    "Basic": "\u57fa\u7840",
    "Bell Icon": "\u94c3\u58f0\u56fe\u6807",
    "Besides Write permission, user can also share the library.": "\u9664\u4e86\u53ef\u8bfb\u5199\u6743\u9650\uff0c\u7528\u6237\u8fd8\u53ef\u4ee5\u5171\u4eab\u8d44\u6599\u5e93\u3002",
    "Branding": "\u54c1\u724c\u5b9a\u5236",
    "Broken (please contact your administrator to fix this library)": "Broken (\u8bf7\u8054\u7cfb\u4f60\u7684\u7ba1\u7406\u5458\u6765\u4fee\u590d\u8be5\u8d44\u6599\u5e93)",
    "Broken ({repo_id_placeholder})": "\u5df2\u635f\u574f ({repo_id_placeholder})",
    "By day": "\u6309\u5929",
    "By month": "\u6309\u6708",
    "By name ascending": "\u6309\u540d\u79f0\u5347\u5e8f",
    "By name descending": "\u6309\u540d\u79f0\u964d\u5e8f",
    "By quarter": "\u6309\u5b63\u5ea6",
    "By size ascending": "\u6309\u5927\u5c0f\u5347\u5e8f",
    "By size descending": "\u6309\u5927\u5c0f\u964d\u5e8f",
    "By time ascending": "\u6309\u65f6\u95f4\u5347\u5e8f",
    "By time descending": "\u6309\u65f6\u95f4\u964d\u5e8f",
    "By week": "\u6309\u5468",
    "By year": "\u6309\u5e74",
    "Can not copy folder %(src)s to its subfolder %(des)s": "\u4e0d\u80fd\u628a\u76ee\u5f55 %(src)s \u590d\u5236\u5230\u5b83\u7684\u5b50\u76ee\u5f55 %(des)s \u4e2d",
    "Can not move folder %(src)s to its subfolder %(des)s": "\u4e0d\u80fd\u628a\u76ee\u5f55 %(src)s \u79fb\u52a8\u5230\u5b83\u7684\u5b50\u76ee\u5f55 %(des)s \u4e2d",
    "Cancel": "\u53d6\u6d88",
    "Cancel All": "\u53d6\u6d88\u5168\u90e8",
    "Cannot move parent page to child page": "\u4e0d\u80fd\u628a\u7236\u9875\u9762\u79fb\u52a8\u5230\u5b50\u9875\u9762",
    "Capture information": "\u62cd\u6444\u4fe1\u606f",
    "Capture time": "\u62cd\u6444\u65f6\u95f4",
    "Certificate": "\u8bc1\u4e66",
    "Change": "\u4fee\u6539",
    "Change Password": "\u4fee\u6539\u5bc6\u7801",
    "Change Password of Library {placeholder}": "\u66f4\u6539\u8d44\u6599\u5e93 {placeholder} \u5bc6\u7801",
    "Change cover": "\u66f4\u6362\u5c01\u9762",
    "Change group to department": "\u5c06\u7fa4\u7ec4\u66f4\u6539\u4e3a\u90e8\u95e8",
    "Change to department": "\u66f4\u6539\u4e3a\u90e8\u95e8",
    "Changes": "\u6539\u52a8",
    "Checkbox": "\u52fe\u9009",
    "Child tags count": "\u5b50\u6807\u7b7e\u6570\u91cf",
    "Choose date": "\u9009\u62e9\u65e5\u671f\u8303\u56f4",
    "Clean": "\u6e05\u7a7a",
    "Clean invalid share links": "\u6e05\u9664\u65e0\u6548\u7684\u5171\u4eab\u94fe\u63a5",
    "Clean invalid upload links": "\u6e05\u9664\u65e0\u6548\u7684\u4e0a\u4f20\u94fe\u63a5",
    "Clean succeeded.": "\u6e05\u9664\u6210\u529f\u3002",
    "Cleaned trash": "\u6e05\u7a7a\u56de\u6536\u7ad9",
    "Clear": "\u6e05\u7a7a",
    "Clear Trash": "\u6e05\u7a7a\u56de\u6536\u7ad9",
    "Clear files in trash and history\uff1a": "\u6e05\u7a7a\u56de\u6536\u7ad9\u548c\u5386\u53f2\u4fe1\u606f\u4e2d\u7684\u6587\u4ef6",
    "Clear search": "\u6e05\u7a7a\u641c\u7d22",
    "Clear selected": "\u6e05\u9664\u6240\u9009\u5185\u5bb9",
    "Click to load more": "\u70b9\u51fb\u52a0\u8f7d\u66f4\u591a",
    "Clients": "\u5ba2\u6237\u7aef",
    "Close": "\u5173\u95ed",
    "Close (Esc)": "\u5173\u95ed(Esc)",
    "Code": "\u4ee3\u7801",
    "Collaborator": "\u534f\u4f5c\u4eba",
    "Collapse": "\u6298\u53e0",
    "Collapse all": "\u6298\u53e0\u5168\u90e8",
    "Color": "\u989c\u8272",
    "Color space": "\u8272\u5f69\u7a7a\u95f4",
    "Community Edition": "\u793e\u533a\u7248",
    "Compressed": "\u538b\u7f29\u6587\u4ef6",
    "Configure Seafile": "\u914d\u7f6e Seafile",
    "Configure your Identity Provider": "\u914d\u7f6e\u4f60\u7684 Identity Provider",
    "Confirm": "\u786e\u8ba4",
    "Confirm Password": "\u786e\u8ba4\u5bc6\u7801",
    "Confirm password": "\u786e\u8ba4\u5bc6\u7801",
    "Connect": "\u8fde\u63a5",
    "Contact Email": "\u8054\u7cfb\u4eba\u90ae\u7bb1",
    "Contact Email:": "\u8054\u7cfb\u4eba\u90ae\u7bb1\uff1a",
    "Contact Information": "\u8054\u7cfb\u4eba\u4fe1\u606f",
    "Contact email": "\u8054\u7cfb\u90ae\u7bb1",
    "Contact information is required.": "\u8054\u7cfb\u4eba\u4e3a\u5fc5\u586b\u9879\u3002",
    "Content Scan Records": "\u6587\u4ef6\u626b\u63cf\u8bb0\u5f55",
    "Convert & Export": "\u8f6c\u6362 & \u5bfc\u51fa",
    "Convert Wiki": "\u8f6c\u6362\u77e5\u8bc6\u5e93",
    "Convert to Markdown": "\u8f6c\u6362\u4e3a Markdown",
    "Convert to docx": "\u8f6c\u6362\u4e3a docx",
    "Convert to new Wiki": "\u8f6c\u6362\u4e3a\u65b0\u77e5\u8bc6\u5e93",
    "Convert to sdoc": "\u8f6c\u6362\u4e3a sdoc",
    "Convert with ONLYOFFICE": "\u7528 ONLYOFFICE \u8f6c\u6362",
    "Converting": "\u8f6c\u6362\u4e2d",
    "Converting, please wait...": "\u8f6c\u6362\u4e2d\uff0c\u8bf7\u7a0d\u5019...",
    "Converting...": "\u8f6c\u6362\u4e2d...",
    "Copied": "\u5df2\u590d\u5236",
    "Copied link to clipboard": "\u590d\u5236\u94fe\u63a5\u5230\u526a\u8d34\u677f",
    "Copy": "\u590d\u5236",
    "Copy failed": "\u590d\u5236\u5931\u8d25",
    "Copy link": "\u590d\u5236\u94fe\u63a5",
    "Copy selected": "\u590d\u5236\u6240\u9009\u5185\u5bb9",
    "Copy selected item(s) to:": "\u5c06\u5df2\u9009\u6761\u76ee\u590d\u5236\u5230\uff1a",
    "Copy the IdP's certificate and paste it here. The certificate format is as follows:": "\u590d\u5236 IdP \u7684\u8bc1\u4e66\uff0c\u7c98\u8d34\u5230\u6b64\u5904\u3002\u8bc1\u4e66\u683c\u5f0f\u5982\u4e0b\u6240\u793a\uff1a",
    "Copy the domain DNS TXT and add it to your domain's DNS records, then click the button to verify domain ownership. You must verify the ownership of domain before Single Sign-On.": "\u590d\u5236\u57df\u540d DNS TXT\uff0c\u5c06\u5b83\u6dfb\u52a0\u5230\u4f60\u7684\u57df\u540d DNS \u8bb0\u5f55\u4e2d\uff0c\u7136\u540e\u70b9\u51fb\u6309\u94ae\u9a8c\u8bc1\u57df\u540d\u7684\u6240\u6709\u6743\u3002\u5355\u70b9\u767b\u5f55\u524d\u5fc5\u987b\u9a8c\u8bc1\u57df\u540d\u6240\u6709\u6743\u3002",
    "Copy {num} items": "\u590d\u5236 {num} \u4e2a\u6761\u76ee",
    "Copy {placeholder} to": "\u590d\u5236 {placeholder} \u5230",
    "Copyright Infringement": "\u7248\u6743\u4fb5\u72af",
    "Count": "\u6570\u91cf",
    "Cover": "\u5c01\u9762",
    "Create": "\u521b\u5efa",
    "Create At": "\u521b\u5efa\u65f6\u95f4",
    "Create Group": "\u521b\u5efa\u7fa4\u7ec4",
    "Create Library": "\u521b\u5efa\u8d44\u6599\u5e93",
    "Create Report": "\u751f\u6210\u7edf\u8ba1\u62a5\u8868",
    "Create a DNS TXT record to confirm the ownership of your Email Domain.": "\u521b\u5efa\u4e00\u6761 DNS TXT \u8bb0\u5f55\u6765\u786e\u8ba4\u90ae\u7bb1\u57df\u540d\u6240\u6709\u6743\u3002",
    "Create a new tag": "\u65b0\u5efa\u6807\u7b7e",
    "Create top department": "\u521b\u5efa\u9876\u5c42\u90e8\u95e8",
    "Created": "\u5df2\u521b\u5efa",
    "Created At": "\u521b\u5efa\u65f6\u95f4",
    "Created Files": "\u521b\u5efa\u7684\u6587\u4ef6",
    "Created draft": "\u521b\u5efa\u8349\u7a3f",
    "Created file": "\u521b\u5efa\u6587\u4ef6",
    "Created folder": "\u521b\u5efa\u76ee\u5f55",
    "Created group {group_name}": "\u5df2\u521b\u5efa\u7fa4\u7ec4 {group_name}",
    "Created library": "\u521b\u5efa\u4e86\u8d44\u6599\u5e93",
    "Created library {library_name} with {owner} as its owner": "\u521b\u5efa\u8d44\u6599\u5e93 {library_name} \u5e76\u628a\u8d44\u6599\u5e93\u62e5\u6709\u8005\u8bbe\u4e3a {owner}",
    "Created time": "\u521b\u5efa\u65f6\u95f4",
    "Created {n} files": "\u521b\u5efa {n} \u4e2a\u6587\u4ef6",
    "Creator": "\u521b\u5efa\u8005",
    "Current Connected Devices": "\u5f53\u524d\u8fde\u63a5\u7684\u8bbe\u5907",
    "Current Library": "\u5f53\u524d\u8d44\u6599\u5e93",
    "Current Path: ": "\u5f53\u524d\u8def\u5f84\uff1a",
    "Current Version": "\u5f53\u524d\u7248\u672c",
    "Current page": "\u5f53\u524d\u9875\u9762",
    "Current password": "\u5f53\u524d\u5bc6\u7801",
    "Current password cannot be blank": "\u5f53\u524d\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a",
    "Current path: ": "\u5f53\u524d\u8def\u5f84\uff1a",
    "Custom CSS": "\u5b9a\u5236\u7684 CSS",
    "Custom properties": "\u81ea\u5b9a\u4e49\u5c5e\u6027",
    "Custom sharing permissions": "\u81ea\u5b9a\u4e49\u5171\u4eab\u6743\u9650",
    "Customer Portal": "\u5ba2\u6237\u95e8\u6237",
    "Customize URL": "\u81ea\u5b9a\u4e49 URL",
    "DNS TXT Value": "DNS TXT \u8bb0\u5f55\u503c",
    "Daily Admin": "\u65e5\u5e38\u7ba1\u7406\u5458",
    "Database": "\u6570\u636e\u5e93",
    "Date": "\u65e5\u671f",
    "Date Invalid.": "\u65e5\u671f\u65e0\u6548\u3002",
    "Day": "\u65e5",
    "Decrypt document": "\u89e3\u5bc6\u6587\u6863",
    "Default": "\u9ed8\u8ba4",
    "Default Admin": "\u9ed8\u8ba4\u7ba1\u7406\u5458",
    "Delete": "\u5220\u9664",
    "Delete Account": "\u6ce8\u9500\u8d26\u53f7",
    "Delete Department": "\u5220\u9664\u90e8\u95e8",
    "Delete Expired Invitations": "\u5220\u9664\u8fc7\u671f\u9080\u8bf7",
    "Delete File": "\u5220\u9664\u6587\u4ef6",
    "Delete Folder": "\u5220\u9664\u76ee\u5f55",
    "Delete Group": "\u5220\u9664\u7fa4\u7ec4",
    "Delete Institution": "\u5220\u9664\u673a\u6784",
    "Delete Library": "\u5220\u9664\u8d44\u6599\u5e93",
    "Delete Member": "\u5220\u9664\u6210\u5458",
    "Delete Notification": "\u5220\u9664\u901a\u77e5",
    "Delete Organization": "\u5220\u9664\u56e2\u4f53",
    "Delete Password": "\u5220\u9664\u5bc6\u7801",
    "Delete T&C": "\u5220\u9664\u6761\u6b3e",
    "Delete Time": "\u5220\u9664\u65f6\u95f4",
    "Delete User": "\u5220\u9664\u7528\u6237",
    "Delete Users": "\u5220\u9664\u7528\u6237",
    "Delete WebDAV Password": "\u5220\u9664 WebDAV \u5bc6\u7801",
    "Delete Wiki": "\u5220\u9664\u77e5\u8bc6\u5e93",
    "Delete department": "\u5220\u9664\u90e8\u95e8",
    "Delete file": "\u5220\u9664\u6587\u4ef6",
    "Delete files from this device the next time it comes online.": "\u5728\u6b64\u8bbe\u5907\u4e0b\u6b21\u4e0a\u7ebf\u65f6\u5220\u9664\u6b64\u8bbe\u5907\u4e0a\u7684\u6587\u4ef6\u3002",
    "Delete folder": "\u5220\u9664\u6587\u4ef6\u5939",
    "Delete group": "\u5220\u9664\u7fa4\u7ec4",
    "Delete page": "\u5220\u9664\u9875\u9762",
    "Delete property": "\u5220\u9664\u5c5e\u6027",
    "Delete selected": "\u5220\u9664\u5df2\u9009\u4e2d",
    "Delete share link": "\u5220\u9664\u5171\u4eab\u94fe\u63a5",
    "Delete share links": "\u5220\u9664\u5171\u4eab\u94fe\u63a5",
    "Delete tag": "\u5220\u9664\u6807\u7b7e",
    "Delete tags": "\u5220\u9664\u6807\u7b7e",
    "Delete upload links": "\u5220\u9664\u4e0a\u4f20\u94fe\u63a5",
    "Deleted": "\u5220\u9664\u7684",
    "Deleted Libraries": "\u5df2\u5220\u9664\u7684\u8d44\u6599\u5e93",
    "Deleted Time": "\u5220\u9664\u65f6\u95f4",
    "Deleted directories": "\u5220\u9664\u7684\u76ee\u5f55",
    "Deleted draft": "\u5220\u9664\u8349\u7a3f",
    "Deleted file": "\u5220\u9664\u6587\u4ef6",
    "Deleted files": "\u5220\u9664\u7684\u6587\u4ef6",
    "Deleted folder": "\u5220\u9664\u76ee\u5f55",
    "Deleted group {group_name}": "\u5df2\u5220\u9664\u7fa4\u7ec4 {group_name}",
    "Deleted library": "\u5220\u9664\u4e86\u8d44\u6599\u5e93",
    "Deleted library {library_name}": "\u5220\u9664\u8d44\u6599\u5e93 {library_name}",
    "Deleted option": "\u5220\u9664\u9009\u9879",
    "Deleted user %s": "\u5220\u9664\u7528\u6237 %s",
    "Deleted user {user}": "\u5df2\u5220\u9664\u7528\u6237 {user}",
    "Department ID": "\u90e8\u95e8 ID",
    "Department renamed": "\u90e8\u95e8\u5df2\u91cd\u547d\u540d",
    "Departments": "\u7ec4\u7ec7\u67b6\u6784",
    "Description": "\u63cf\u8ff0",
    "Description generated": "\u63cf\u8ff0\u5df2\u751f\u6210",
    "Description is required": "\u63cf\u8ff0\u4e3a\u5fc5\u586b\u9879",
    "Desktop": "\u684c\u9762\u5ba2\u6237\u7aef",
    "Detail": "\u4fee\u6539\u5185\u5bb9",
    "Details": "\u8be6\u60c5",
    "Device": "\u8bbe\u5907",
    "Device Name": "\u8bbe\u5907\u540d\u79f0",
    "Device make": "\u8bbe\u5907\u5236\u9020\u5546",
    "Device model": "\u8bbe\u5907\u578b\u53f7",
    "Devices": "\u8bbe\u5907",
    "Diagram": "\u56fe\u8868",
    "Dimensions": "\u5c3a\u5bf8",
    "Direct download link": "\u76f4\u63a5\u4e0b\u8f7d\u94fe\u63a5",
    "Direct download link is copied to the clipboard.": "\u76f4\u63a5\u4e0b\u8f7d\u8fde\u63a5\u5df2\u590d\u5236\u5230\u526a\u5207\u677f\u3002",
    "Disable SAML user email / password login": "\u7981\u7528 SAML \u7528\u6237\u90ae\u7bb1/\u5bc6\u7801\u767b\u5f55",
    "Disable Two-Factor Authentication": "\u5173\u95ed\u4e24\u6b65\u9a8c\u8bc1",
    "Disable sync with any folder": "\u7981\u7528\u4e0e\u4efb\u4f55\u6587\u4ef6\u5939\u540c\u6b65",
    "Disable user clean trash": "\u7981\u7528\u7528\u6237\u6e05\u7406\u56de\u6536\u7ad9",
    "Disconnect": "\u65ad\u5f00\u8fde\u63a5",
    "Display files": "\u663e\u793a\u6587\u4ef6",
    "Do not automatically delete files": "\u4e0d\u81ea\u52a8\u5220\u9664\u6587\u4ef6",
    "Do you really want to turn off OCR? Existing OCR results will be deleted.": "\u4f60\u771f\u7684\u8981\u5173\u95ed OCR \u5417\uff1f\u73b0\u6709\u7684 OCR \u7ed3\u679c\u5c06\u88ab\u5220\u9664\u3002",
    "Do you really want to turn off extended properties? Existing properties will all be deleted.": "\u4f60\u771f\u7684\u8981\u5173\u95ed\u6269\u5c55\u5c5e\u6027\u5417\uff1f\u73b0\u6709\u5c5e\u6027\u5c06\u5168\u90e8\u5220\u9664\u3002",
    "Do you really want to turn off face recognition? Existing results will all be deleted.": "\u4f60\u771f\u7684\u60f3\u5173\u95ed\u4eba\u8138\u8bc6\u522b\u5417\uff1f\u73b0\u6709\u7ed3\u679c\u5c06\u5168\u90e8\u5220\u9664\u3002",
    "Do you really want to turn off tags? Existing tags will all be deleted.": "\u4f60\u771f\u7684\u8981\u5173\u95ed\u6807\u7b7e\u5417\uff1f\u73b0\u6709\u6807\u7b7e\u5c06\u5168\u90e8\u5220\u9664\u3002",
    "Document": "\u6587\u6863",
    "Document convertion failed.": "\u6587\u6863\u8f6c\u6362\u5931\u8d25\u3002",
    "Document keywords": "\u6587\u6863\u5173\u952e\u8bcd",
    "Domain verified": "\u57df\u540d\u5df2\u9a8c\u8bc1",
    "Don't ignore": "\u4e0d\u5ffd\u7565",
    "Don't keep history": "\u4e0d\u4fdd\u7559\u5386\u53f2",
    "Don't replace": "\u4e0d\u66ff\u6362",
    "Don't send emails": "\u4e0d\u53d1\u9001\u90ae\u4ef6",
    "Don't show empty values": "\u4e0d\u663e\u793a\u7a7a\u503c",
    "Done": "\u5df2\u5b8c\u6210",
    "Down": "\u964d\u5e8f",
    "Download": "\u4e0b\u8f7d",
    "Download an example file": "\u4e0b\u8f7d\u793a\u4f8b\u6587\u4ef6",
    "Download and upload": "\u4e0b\u8f7d\u548c\u4e0a\u4f20",
    "Drag and drop files or folders here.": "\u62d6\u653e\u6587\u4ef6\u6216\u76ee\u5f55\u5230\u8fd9\u91cc\u3002",
    "Duplicate": "\u590d\u5236",
    "Duplicate page": "\u590d\u5236\u9875\u9762",
    "Edit": "\u7f16\u8f91",
    "Edit format settings": "\u7f16\u8f91\u683c\u5f0f\u8bbe\u7f6e",
    "Edit labels": "\u7f16\u8f91\u6807\u7b7e",
    "Edit metadata properties": "\u7f16\u8f91\u5143\u6570\u636e\u5c5e\u6027",
    "Edit multiple select": "\u7f16\u8f91\u591a\u9009",
    "Edit on cloud and download": "\u4e91\u7aef\u7f16\u8f91\u4e0e\u4e0b\u8f7d",
    "Edit on cloud only": "\u4ec5\u4e91\u7aef\u7f16\u8f91",
    "Edit permission": "\u7f16\u8f91\u6743\u9650",
    "Edit single select": "\u7f16\u8f91\u5355\u9009",
    "Edit succeeded": "\u6743\u9650\u4fee\u6539\u6210\u529f",
    "Edit succeeded.": "\u6743\u9650\u4fee\u6539\u6210\u529f\u3002",
    "Edit tag": "\u7f16\u8f91\u6807\u7b7e",
    "Email": "\u90ae\u7bb1",
    "Email Domain": "\u90ae\u7bb1\u57df\u540d",
    "Email Notification": "\u90ae\u4ef6\u901a\u77e5",
    "Email is invalid.": "\u90ae\u7bb1\u65e0\u6548\u3002",
    "Email notification updated": "\u90ae\u7bb1\u901a\u77e5\u5df2\u66f4\u65b0",
    "Emails": "\u90ae\u7bb1",
    "Emails, separated by ','": "\u8f93\u5165\u90ae\u7bb1\uff0c\u591a\u4e2a\u4ee5,\u5206\u9694",
    "Emojis": "\u8868\u60c5\u7b26\u53f7",
    "Empty": "\u6682\u65e0",
    "Enable OCR": "\u5f00\u542f OCR",
    "Enable Two-Factor Authentication": "\u5f00\u542f\u4e24\u6b65\u9a8c\u8bc1",
    "Enable branding CSS": "\u5f00\u542f\u54c1\u724c CSS",
    "Enable departments feature": "\u5f00\u542f\u90e8\u95e8\u529f\u80fd",
    "Enable extended properties": "\u6587\u4ef6\u6269\u5c55\u5c5e\u6027",
    "Enable face recognition to identify people in your photos.": "\u542f\u7528\u4eba\u8138\u8bc6\u522b\u4ee5\u8bc6\u522b\u7167\u7247\u4e2d\u7684\u4eba\u50cf\u3002",
    "Enable system admin to add Terms and Conditions, and all users will have to accept the terms.": "\u5141\u8bb8\u7cfb\u7edf\u7ba1\u7406\u5458\u6dfb\u52a0\u6761\u6b3e\uff0c\u5e76\u4e14\u6240\u6709\u7528\u6237\u90fd\u5fc5\u987b\u63a5\u53d7\u8be5\u6761\u6b3e\u3002",
    "Enable tags to add tags to files and search files by tags.": "\u542f\u7528\u6807\u7b7e\u529f\u80fd\u4ee5\u5411\u6587\u4ef6\u6dfb\u52a0\u6807\u7b7e\u5e76\u6309\u6807\u7b7e\u641c\u7d22\u6587\u4ef6\u3002",
    "Enable terms and conditions": "\u5f00\u542f\u6761\u6b3e\u548c\u6761\u4ef6",
    "Enable two factor authentication": "\u5f00\u542f\u4e24\u6b65\u9a8c\u8bc1",
    "Enable users to clean trash": "\u5f00\u542f\u7528\u6237\u6e05\u7406\u56de\u6536\u7ad9",
    "Enable users to share libraries to any groups in the system.": "\u5141\u8bb8\u7528\u6237\u5c06\u8d44\u6599\u5e93\u5171\u4eab\u7ed9\u7cfb\u7edf\u4e2d\u7684\u4efb\u4f55\u7fa4\u7ec4\u3002",
    "Enable\u00a0sharing\u00a0to\u00a0all\u00a0groups": "\u5f00\u542f\u6240\u6709\u7fa4\u7ec4\u5171\u4eab",
    "Encrypt": "\u52a0\u5bc6",
    "Encrypted library": "\u52a0\u5bc6\u8d44\u6599\u5e93",
    "End date": "\u7ed3\u675f\u65e5\u671f",
    "Enter characters to start searching": "\u8f93\u5165\u5b57\u7b26\u5f00\u59cb\u641c\u7d22",
    "Error": "\u9519\u8bef",
    "Errors": "\u9519\u8bef",
    "European": "\u6b27\u6d32",
    "Exact date": "\u7cbe\u786e\u65e5\u671f",
    "Exit Institution Admin": "\u9000\u51fa\u673a\u6784\u7ba1\u7406",
    "Exit Organization Admin": "\u9000\u51fa\u56e2\u961f\u7ba1\u7406",
    "Exit System Admin": "\u9000\u51fa\u7cfb\u7edf\u7ba1\u7406",
    "Expand": "\u5c55\u5f00",
    "Expand all": "\u5c55\u5f00\u5168\u90e8",
    "Expiration": "\u8fc7\u671f\u65f6\u95f4",
    "Expiration date": "\u8fc7\u671f\u65e5\u671f",
    "Expiration days": "\u8fc7\u671f\u5929\u6570",
    "Expiration time": "\u8fc7\u671f\u65f6\u95f4",
    "Expired": "\u5df2\u8fc7\u671f",
    "Expired at": "\u8fc7\u671f\u65f6\u95f4",
    "Export": "\u5bfc\u51fa",
    "Export Excel": "\u5bfc\u51fa\u5230 Excel",
    "Export as docx": "\u5bfc\u51fa\u4e3a docx",
    "Export as zip": "\u5bfc\u51fa\u4e3a zip",
    "Export options": "\u5bfc\u51fa\u9009\u9879",
    "Export tags": "\u5bfc\u5165\u6807\u7b7e",
    "Exporting": "\u5bfc\u51fa",
    "Exporting...": "\u5bfc\u51fa\u4e2d...",
    "Exposure time": "\u66dd\u5149\u65f6\u95f4",
    "Extended properties": "\u6269\u5c55\u5c5e\u6027",
    "Extended properties are being built.": "\u6269\u5c55\u5c5e\u6027\u6b63\u5728\u521b\u5efa\u4e2d\u3002",
    "Extension Prompts": "\u6269\u5c55\u63d0\u793a",
    "Extensions of text files that can be online previewed, each suffix is separated by a comma.": "\u53ef\u5728\u7ebf\u9884\u89c8\u7684\u6587\u672c\u6587\u4ef6\u6269\u5c55\u540d\uff0c\u7528\u9017\u53f7\u5206\u9694\u3002",
    "Extract file detail": "\u63d0\u53d6\u6587\u4ef6\u8be6\u7ec6\u4fe1\u606f",
    "Extract file details": "\u63d0\u53d6\u6587\u4ef6\u8be6\u7ec6\u4fe1\u606f",
    "Extracting file details by AI...": "\u6b63\u5728\u901a\u8fc7 AI \u63d0\u53d6\u6587\u4ef6\u8be6\u7ec6\u4fe1\u606f...",
    "Extracting text by AI...": "\u6b63\u5728\u901a\u8fc7 AI \u63d0\u53d6\u6587\u672c...",
    "F number": "\u5149\u5708",
    "Face recognition": "\u4eba\u8138\u8bc6\u522b",
    "Failed": "\u5931\u8d25",
    "Failed imported options": "\u5bfc\u5165\u6807\u7b7e\u5931\u8d25",
    "Failed to add linked tags": "\u589e\u52a0\u94fe\u63a5\u6807\u7b7e\u5931\u8d25",
    "Failed to add people photos": "\u589e\u52a0\u4eba\u50cf\u7167\u7247\u5931\u8d25",
    "Failed to add tags": "\u589e\u52a0\u6807\u7b7e\u5931\u8d25",
    "Failed to add {email_placeholder}: {error_msg_placeholder}": "\u6dfb\u52a0 {email_placeholder} \u5931\u8d25\uff1a {error_msg_placeholder}",
    "Failed to convert {name}.": "{name} \u8f6c\u6362\u5931\u8d25",
    "Failed to copy %(name)s": "\u590d\u5236 %(name)s \u5931\u8d25",
    "Failed to copy %(name)s and %(amount)s other item(s).": "\u590d\u5236 %(name)s \u548c\u5176\u4ed6 %(amount)s \u9879\u6761\u76ee\u5931\u8d25\u3002",
    "Failed to copy %(name)s.": "\u590d\u5236 %(name)s \u9879\u6761\u76ee\u5931\u8d25\u3002",
    "Failed to copy files to another library.": "\u6587\u4ef6\u590d\u5236\u5931\u8d25\u3002",
    "Failed to delete %(virus_file) from library %(library): %(error_msg)": "\u65e0\u6cd5\u5220\u9664\u8d44\u6599\u5e93 %(library) \u4e2d\u7684  %(virus_file)  : %(error_msg)",
    "Failed to delete linked tags": "\u5220\u9664\u94fe\u63a5\u6807\u7b7e\u5931\u8d25",
    "Failed to delete property": "\u5220\u9664\u5c5e\u6027\u5931\u8d25",
    "Failed to delete records": "\u5220\u9664\u8bb0\u5f55\u5931\u8d25",
    "Failed to delete tags": "\u5220\u9664\u6807\u7b7e\u5931\u8d25",
    "Failed to delete {name}": "\u5220\u9664 {name} \u5931\u8d25",
    "Failed to delete {name} and {n} other items.": "\u6ca1\u80fd\u5220\u9664 {name} \u548c {n} \u4e2a\u5176\u4ed6\u6761\u76ee\u3002",
    "Failed to delete {name}.": "\u5220\u9664 {name} \u5931\u8d25\u3002",
    "Failed to download. The total size of the files exceeded the limit.": "\u4e0b\u8f7d\u5931\u8d25\u3002\u6587\u4ef6\u603b\u5927\u5c0f\u8d85\u8fc7\u4e86\u9650\u5236\u3002",
    "Failed to duplicate file": "\u590d\u5236\u6587\u4ef6\u5931\u8d25",
    "Failed to duplicate folder": "\u590d\u5236\u76ee\u5f55\u5931\u8d25",
    "Failed to duplicate page": "\u590d\u5236\u9875\u9762\u5931\u8d25",
    "Failed to export. Please check whether the size of table attachments exceeds the limit.": "\u5bfc\u51fa\u5931\u8d25\u3002\u8bf7\u68c0\u67e5\u8868\u9644\u4ef6\u7684\u5927\u5c0f\u662f\u5426\u8d85\u8fc7\u9650\u5236\u3002",
    "Failed to extract file details": "\u63d0\u53d6\u6587\u4ef6\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25",
    "Failed to extract text": "\u63d0\u53d6\u6587\u672c\u5931\u8d25",
    "Failed to generate description": "\u751f\u6210\u63cf\u8ff0\u5931\u8d25",
    "Failed to generate file tags": "\u751f\u6210\u6587\u4ef6\u6807\u7b7e\u5931\u8d25",
    "Failed to ignore %(virus_file) from library %(library): %(error_msg)": "\u65e0\u6cd5\u5ffd\u7565\u8d44\u6599\u5e93 %(library) \u4e2d\u7684 %(virus_file) : %(error_msg)",
    "Failed to import tags. Please reupload.": "\u6807\u7b7e\u5bfc\u5165\u5931\u8d25\u3002\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002",
    "Failed to insert property": "\u63d2\u5165\u5c5e\u6027\u5931\u8d25",
    "Failed to merge tags": "\u5408\u5e76\u6807\u7b7e\u5931\u8d25",
    "Failed to modify filter": "\u66f4\u6539\u8fc7\u6ee4\u5931\u8d25",
    "Failed to modify group": "\u66f4\u6539\u5206\u7ec4\u5931\u8d25",
    "Failed to modify hidden properties": "\u66f4\u6539\u9690\u85cf\u5c5e\u6027\u5931\u8d25",
    "Failed to modify people name": "\u4fee\u6539\u4eba\u5458\u59d3\u540d\u5931\u8d25",
    "Failed to modify property data": "\u66f4\u6539\u5c5e\u6027\u6570\u636e\u5931\u8d25",
    "Failed to modify property order": "\u4fee\u6539\u5c5e\u6027\u987a\u5e8f\u5931\u8d25",
    "Failed to modify records": "\u66f4\u6539\u8bb0\u5f55\u5931\u8d25",
    "Failed to modify settings": "\u4fee\u6539\u8bbe\u7f6e\u5931\u8d25",
    "Failed to modify sort": "\u66f4\u6539\u6392\u5e8f\u5931\u8d25",
    "Failed to modify tags": "\u66f4\u6539\u6807\u7b7e\u5931\u8d25",
    "Failed to move %(name)s and %(amount)s other item(s).": "\u79fb\u52a8 %(name)s \u548c\u5176\u4ed6 %(amount)s \u9879\u6761\u76ee\u5931\u8d25\u3002",
    "Failed to move %(name)s.": "\u79fb\u52a8 %(name)s \u9879\u6761\u76ee\u5931\u8d25\u3002",
    "Failed to move file": "\u79fb\u52a8\u6587\u4ef6\u5931\u8d25",
    "Failed to move files to another library.": "\u6587\u4ef6\u79fb\u52a8\u5931\u8d25\u3002",
    "Failed to move folder": "\u79fb\u52a8\u76ee\u5f55\u5931\u8d25",
    "Failed to move {name}.": "\u79fb\u52a8 {name} \u5931\u8d25\u3002",
    "Failed to remove people photos": "\u5220\u9664\u4eba\u7269\u7167\u7247\u5931\u8d25",
    "Failed to rename property": "\u91cd\u547d\u540d\u5c5e\u6027\u5931\u8d25",
    "Failed to restore records": "\u6062\u590d\u8bb0\u5f55\u5931\u8d25",
    "Failed to restore tags": "\u8fd8\u539f\u6807\u7b7e\u5931\u8d25",
    "Failed to restore {name}": "\u6ca1\u80fd\u6062\u590d {name}",
    "Failed to restore {name} and {n} other items": "\u6ca1\u80fd\u6062\u590d {name} \u548c {n} \u4e2a\u5176\u4ed6\u6761\u76ee",
    "Failed to save": "\u4fdd\u5b58\u5931\u8d25",
    "Failed to send to {email_placeholder}: {errorMsg_placeholder}": "\u53d1\u9001\u7ed9  {email_placeholder}\u5931\u8d25\uff1a{errorMsg_placeholder}",
    "Failed to set people cover photo": "\u8bbe\u7f6e\u4eba\u50cf\u5c01\u9762\u7167\u7247\u5931\u8d25",
    "Failed to unshare {name}": "{name} \u53d6\u6d88\u5171\u4eab\u5931\u8d25",
    "Failed to upload {file_name}.": "{file_name} \u4e0a\u4f20\u5931\u8d25\u3002",
    "Failed. Please check the network.": "\u64cd\u4f5c\u5931\u8d25\u3002\u8bf7\u68c0\u67e5\u7f51\u7edc\u662f\u5426\u5df2\u8fde\u63a5\u3002",
    "Favicon": "\u7f51\u7ad9\u56fe\u6807",
    "Favorites": "\u6536\u85cf\u5939",
    "File": "\u6587\u4ef6",
    "File Access": "\u6587\u4ef6\u8bbf\u95ee",
    "File Operations": "\u6587\u4ef6\u64cd\u4f5c",
    "File Scan": "\u6587\u4ef6\u626b\u63cf",
    "File Update": "\u6587\u4ef6\u66f4\u65b0",
    "File Upload": "\u6587\u4ef6\u4e0a\u4f20",
    "File Uploading...": "\u6587\u4ef6\u4e0a\u4f20\u4e2d...",
    "File already exists.": "\u6587\u4ef6\u5df2\u5b58\u5728\u3002",
    "File collaborators": "\u6587\u4ef6\u534f\u4f5c\u4eba",
    "File count": "\u6587\u4ef6\u4e2a\u6570",
    "File details": "\u6587\u4ef6\u7ec6\u8282",
    "File details extracted": "\u6587\u4ef6\u8be6\u7ec6\u4fe1\u606f\u5df2\u63d0\u53d6",
    "File download is disabled: the share link traffic of owner is used up.": "\u6587\u4ef6\u4e0b\u8f7d\u5df2\u7981\u7528\uff1a\u5916\u94fe\u62e5\u6709\u8005\u7684\u6d41\u91cf\u5df2\u7528\u5b8c\u3002",
    "File expire time": "\u6587\u4ef6\u8fc7\u671f\u65f6\u95f4",
    "File extension white list": "\u6587\u4ef6\u6269\u5c55\u540d\u767d\u540d\u5355",
    "File extension white list for file upload via web UI and API. For example, \"md;txt;docx\". Empty means no limit.": "\u901a\u8fc7 web UI \u548c API \u4e0a\u4f20\u6587\u4ef6\u65f6\u7684\u6587\u4ef6\u6269\u5c55\u540d\u767d\u540d\u5355\u3002\u4f8b\u5982\uff0c\u201cmd;txt;docx\u201d\u3002\u7a7a\u8868\u793a\u6ca1\u6709\u9650\u5236\u3002",
    "File extensions can only be {placeholder}.": " \u6587\u4ef6\u6269\u5c55\u540d\u53ea\u80fd\u662f {placeholder}\u3002",
    "File is locked by others.": "\u6587\u4ef6\u88ab\u5176\u4ed6\u4eba\u9501\u5b9a\u4e86\u3002",
    "File name": "\u6587\u4ef6\u540d",
    "File owner": "\u6587\u4ef6\u6240\u6709\u8005",
    "File rate": "\u6587\u4ef6\u8bc4\u5206",
    "File reviewer": "\u6587\u4ef6\u5ba1\u6838\u4eba",
    "File size is too large.": "\u6587\u4ef6\u592a\u5927\u3002",
    "File size should be smaller than {max_size_placeholder}.": "\u6587\u4ef6\u5927\u5c0f\u5e94\u5c0f\u4e8e {max_size_placeholder}\u3002",
    "File status": "\u6587\u4ef6\u72b6\u6001",
    "File suffix": "\u6587\u4ef6\u540e\u7f00",
    "File too large": "\u6587\u4ef6\u592a\u5927",
    "File type": "\u6587\u4ef6\u7c7b\u578b",
    "Files": "\u6587\u4ef6",
    "Files and folders": "\u6587\u4ef6\u548c\u76ee\u5f55",
    "Filter": "\u8fc7\u6ee4",
    "Filters": "\u8fc7\u6ee4",
    "Find": "\u67e5\u627e",
    "Find a tag": "\u67e5\u627e\u6807\u7b7e",
    "Find modifiers": "\u67e5\u627e\u4fee\u6539\u4eba",
    "Focal length": "\u7126\u8ddd",
    "Fold": "\u6298\u53e0",
    "Fold the sidebar": "\u6536\u8d77\u4fa7\u8fb9\u680f",
    "Folder": "\u76ee\u5f55",
    "Folder Permission": "\u76ee\u5f55\u6743\u9650",
    "Folder does not exist.": "\u76ee\u5f55\u4e0d\u5b58\u5728\u3002",
    "Folder permission is only effective after the library is shared to users or groups. It is used to fine tune sub-folder permissions.": "\u76ee\u5f55\u6743\u9650\u53ea\u6709\u5728\u5e93\u5171\u4eab\u7ed9\u7528\u6237\u6216\u7ec4\u540e\u624d\u6709\u6548\u3002\u5b83\u7528\u4e8e\u5fae\u8c03\u5b50\u76ee\u5f55\u6743\u9650\u3002",
    "Folders": "\u76ee\u5f55",
    "Force password change": "\u5f3a\u5236\u66f4\u6539\u5bc6\u7801",
    "Force user to change password when account is newly added or reset by admin": "\u5f3a\u5236\u65b0\u7528\u6237\u6216\u8005\u88ab\u7ba1\u7406\u5458\u91cd\u7f6e\u4e86\u5bc6\u7801\u7684\u7528\u6237\uff0c\u5728\u4e0b\u6b21\u767b\u5f55\u65f6\u4fee\u6539\u5bc6\u7801",
    "Force user to use SSO login if SAML account is bound": "\u5982\u679c\u7ed1\u5b9a\u4e86SAML\u8d26\u53f7\uff0c\u5219\u5f3a\u5236\u7528\u6237\u4f7f\u7528SSO\u767b\u5f55",
    "Force user to use a strong password when sign up or change password.": "\u5f3a\u5236\u5728\u65b0\u7528\u6237\u6ce8\u518c\u65f6\u6216\u8005\u7528\u6237\u4fee\u6539\u5bc6\u7801\u65f6\u4f7f\u7528\u5f3a\u5bc6\u7801\u3002",
    "Force users to use password when generating share/upload link.": "\u5f3a\u5236\u7528\u6237\u5728\u751f\u6210\u5171\u4eab/\u4e0a\u4f20\u94fe\u63a5\u65f6\u4f7f\u7528\u5bc6\u7801\u3002",
    "Format": "\u683c\u5f0f",
    "Freeze Document": "\u51bb\u7ed3\u6587\u6863",
    "Freeze user account when failed login attempts exceed limit.": "\u5f53\u7528\u6237\u767b\u5f55\u5931\u8d25\u8d85\u8fc7\u9650\u5236\u65f6\uff0c\u51bb\u7ed3\u7528\u6237\u8d26\u6237\u3002",
    "Freeze user on login failed": "\u51bb\u7ed3\u5931\u8d25\u767b\u5f55\u7684\u7528\u6237",
    "Frozen by {name}": "\u88ab {name} \u51bb\u7ed3",
    "Gallery": "\u753b\u5eca",
    "General information": "\u901a\u7528\u4fe1\u606f",
    "Generate": "\u751f\u6210\u94fe\u63a5",
    "Generate Link": "\u751f\u6210\u94fe\u63a5",
    "Generate description": "\u751f\u6210\u63cf\u8ff0",
    "Generate file tags": "\u751f\u6210\u6587\u4ef6\u6807\u7b7e",
    "Generate links in batch": "\u6279\u91cf\u751f\u6210\u94fe\u63a5",
    "Generate share link": "\u751f\u6210\u5171\u4eab\u94fe\u63a5",
    "Generating description by AI...": "\u6b63\u5728\u901a\u8fc7 AI \u751f\u6210\u63cf\u8ff0...",
    "Germany Russia etc": "\u5fb7\u56fd\u4fc4\u7f57\u65af\u7b49",
    "Global Address Book": "\u901a\u8baf\u5f55",
    "Go to Library": "\u524d\u5f80\u8d44\u6599\u5e93",
    "Greater than or equal to {minDays_placeholder} days": "\u5927\u4e8e\u6216\u7b49\u4e8e {minDays_placeholder} \u5929",
    "Grid": "\u683c\u70b9",
    "Grid view": "\u7f51\u683c\u89c6\u56fe",
    "Group": "\u7fa4\u7ec4",
    "Group Permission": "\u7fa4\u7ec4\u6743\u9650",
    "Group Shares": "\u7fa4\u7ec4\u5171\u4eab",
    "Group by": "\u5206\u7ec4",
    "Group deleted": "\u7fa4\u7ec4\u5df2\u5220\u9664",
    "Group has been transfered": "\u7fa4\u7ec4\u5df2\u88ab\u8f6c\u79fb",
    "Group info": "\u7fa4\u7ec4\u4fe1\u606f",
    "Group members": "\u7fa4\u7ec4\u6210\u5458",
    "Grouped by 1 property": "\u6309 1 \u4e2a\u5c5e\u6027\u5206\u7ec4",
    "Grouped by {name_placeholder} properties": "\u6309\u7167 {name_placeholder} \u5c5e\u6027\u5206\u7ec4",
    "Groups": "\u7fa4\u7ec4",
    "Guest": "\u8bbf\u5ba2",
    "Handled": "\u5df2\u5904\u7406",
    "Help": "\u5e2e\u52a9",
    "Help and resources": "\u5e2e\u52a9\u548c\u8d44\u6e90",
    "Hide": "\u9690\u85cf",
    "Hide all": "\u9690\u85cf\u5168\u90e8",
    "Hide properties": "\u9690\u85cf\u5c5e\u6027",
    "History": "\u5386\u53f2",
    "History Setting": "\u5386\u53f2\u8bbe\u7f6e",
    "History Versions": "\u5386\u53f2\u7248\u672c",
    "ID": "ID",
    "IP": "IP",
    "ISO": "ISO",
    "Identifying portraits...": "\u4eba\u50cf\u8bc6\u522b\u4e2d...",
    "If notifications have not been read within one hour, they will be sent to your mailbox.": "1\u5c0f\u65f6\u5185\u672a\u8bfb\u7684\u901a\u77e5\u4f1a\u53d1\u9001\u5230\u4f60\u7684\u90ae\u7bb1\u3002",
    "If the library is shared to another department, the sharing will be kept.": "\u5982\u679c\u8d44\u6599\u5e93\u5171\u4eab\u7ed9\u5176\u4ed6\u90e8\u95e8\uff0c\u5171\u4eab\u5173\u7cfb\u5c06\u88ab\u4fdd\u7559\u3002",
    "If the library is shared to another user, the sharing will be kept.": "\u5982\u679c\u8d44\u6599\u5e93\u5171\u4eab\u7ed9\u5176\u4ed6\u7528\u6237\uff0c\u5171\u4eab\u5173\u7cfb\u5c06\u88ab\u4fdd\u7559\u3002",
    "If there are multiple items in the cell, a random one will be chosen and be compared with the filter value.": "\u5982\u679c\u5355\u5143\u683c\u4e2d\u6709\u591a\u4e2a\u9879\u76ee\uff0c\u5c06\u9009\u62e9\u4e00\u4e2a\u968f\u673a\u9879\u76ee\u5e76\u5c06\u5176\u4e0e\u7b5b\u9009\u503c\u8fdb\u884c\u6bd4\u8f83\u3002",
    "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.": "\u5982\u679c\u542f\u7528\u6b64\u529f\u80fd\uff0c\u684c\u9762\u5ba2\u6237\u7aef\u5c06\u4e0d\u80fd\u540c\u6b65 Seafile \u76ee\u5f55\u5916\u7684\u76ee\u5f55\u3002",
    "If you don't have any device with you, you can access your account using backup codes.": "\u5982\u679c\u4f60\u8eab\u8fb9\u6ca1\u6709\u8bbe\u5907\uff0c\u53ef\u4ee5\u901a\u8fc7\u5907\u7528\u9a8c\u8bc1\u7801\u6765\u767b\u5f55\u8d26\u6237\u3002",
    "Ignore": "\u5ffd\u7565",
    "Ignored": "\u5df2\u5ffd\u7565",
    "Image saved": "\u56fe\u7247\u5df2\u4fdd\u5b58",
    "Import Users": "\u5bfc\u5165\u7528\u6237",
    "Import members": "\u5bfc\u5165\u6210\u5458",
    "Import members from a .xlsx file": "\u901a\u8fc7 .xlsx \u6587\u4ef6\u5bfc\u5165\u6210\u5458",
    "Import options": "\u5bfc\u5165\u9009\u9879",
    "Import sdoc": "\u5bfc\u5165 sdoc",
    "Import tags": "\u5bfc\u5165\u6807\u7b7e",
    "Import users": "\u5bfc\u5165\u7528\u6237",
    "Import users from a .xlsx file": "\u4ece.xlsx\u540e\u7f00\u6587\u4ef6\u5bfc\u5165\u7528\u6237",
    "Importing sdoc, please wait...": "\u6b63\u5728\u5bfc\u5165sdoc\uff0c\u8bf7\u7a0d\u5019...",
    "In progress": "\u8fdb\u884c\u4e2d",
    "In review": "\u8bc4\u5ba1\u4e2d",
    "Inactive": "\u672a\u6fc0\u6d3b",
    "Info": "\u4fe1\u606f",
    "Institution": "\u673a\u6784",
    "Institution Admin": "\u673a\u6784\u7ba1\u7406",
    "Institutions": "\u673a\u6784",
    "Internal Link": "\u5185\u90e8\u94fe\u63a5",
    "Internal Server Error": "\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef",
    "Internal link has been copied to clipboard": "\u5185\u90e8\u94fe\u63a5\u5df2\u590d\u5236\u5230\u526a\u8d34\u677f",
    "Invalid destination path": "\u76ee\u6807\u8def\u5f84\u65e0\u6548",
    "Invalid filename.": "\u6587\u4ef6\u540d\u65e0\u6548\u3002",
    "Invalid filter": "\u65e0\u6548\u7684\u8fc7\u6ee4\u5668",
    "Invalid month, should be yyyymm.": "\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a\uff1ayyyymm\u3002",
    "Invalid regular expression": "\u65e0\u6548\u7684\u6b63\u5219\u8868\u8fbe\u5f0f",
    "Invisible": "\u4e0d\u53ef\u89c1",
    "Invitations": "\u9080\u8bf7",
    "Invite Guest": "\u9080\u8bf7\u8bbf\u5ba2",
    "Invite Time": "\u9080\u8bf7\u65f6\u95f4",
    "Invite users": "\u9080\u8bf7\u7528\u6237",
    "Invited at": "\u9080\u8bf7\u65f6\u95f4",
    "Inviter": "\u9080\u8bf7\u8005",
    "Is expired": "\u5df2\u8fc7\u671f",
    "It is already shared to user": "\u5df2\u5206\u4eab\u7ed9\u7528\u6237",
    "It is required.": "\u5fc5\u586b\u9879\u3002",
    "It may take some time, please wait.": "\u8bf7\u7a0d\u5019\u3002",
    "Kanban": "\u770b\u677f",
    "Keep full history": "\u4fdd\u7559\u6240\u6709\u5386\u53f2",
    "Keep sharing": "\u4fdd\u7559\u5171\u4eab",
    "Keep sign in": "\u4fdd\u6301\u767b\u5f55",
    "LDAP": "LDAP",
    "LDAP(imported)": "LDAP\uff08\u5df2\u5bfc\u5165\uff09",
    "Label": "\u6807\u7b7e",
    "Label Current State": "\u6807\u8bb0\u5f53\u524d\u7248\u672c",
    "Labels": "\u6807\u7b7e",
    "Language": "\u8bed\u8a00",
    "Language Setting": "\u8bed\u8a00\u8bbe\u7f6e",
    "Last Access": "\u6700\u540e\u8bbf\u95ee\u65f6\u95f4",
    "Last Login": "\u4e0a\u6b21\u767b\u5f55",
    "Last Update": "\u66f4\u65b0\u65f6\u95f4",
    "Last modification": "\u4e0a\u4e00\u4e2a\u4fee\u6539",
    "Last modified by": "\u6700\u8fd1\u4fee\u6539",
    "Last modified time": "\u4fee\u6539\u65f6\u95f4",
    "Last modifier": "\u4fee\u6539\u8005",
    "Leave": "\u9000\u51fa",
    "Leave Group": "\u9000\u51fa\u7fa4\u7ec4",
    "Leave Share": "\u9000\u51fa\u5171\u4eab",
    "Leave Share Wiki": "\u79bb\u5f00\u5171\u4eab\u77e5\u8bc6\u5e93",
    "Leave group": "\u9000\u51fa\u7fa4\u7ec4",
    "Leave this page? The system may not save your changes.": "\u79bb\u5f00\u8fd9\u4e2a\u9875\u9762\uff1f\u4f60\u7684\u4fee\u6539\u53ef\u80fd\u6ca1\u4fdd\u5b58\u3002",
    "Less than or equal to {maxDays_placeholder} days": "\u5c0f\u4e8e\u6216\u7b49\u4e8e {maxDays_placeholder} \u5929",
    "Libraries": "\u8d44\u6599\u5e93",
    "Library": "\u8d44\u6599\u5e93",
    "Library Type": "\u8d44\u6599\u5e93\u7c7b\u578b",
    "Library can not be shared to owner.": "\u8d44\u6599\u5e93\u65e0\u6cd5\u4e0e\u5176\u6240\u6709\u8005\u5171\u4eab\u3002",
    "Library history": "\u8d44\u6599\u5e93\u5386\u53f2",
    "Library password minimum length": "\u8d44\u6599\u5e93\u5bc6\u7801\u6700\u5c0f\u957f\u5ea6",
    "Library share permission not found.": "\u8d44\u6599\u5e93\u5171\u4eab\u6743\u9650\u672a\u627e\u5230\u3002",
    "Limits": "\u7528\u6237\u6570\u9650\u5236",
    "Link": "\u94fe\u63a5",
    "Link has been copied to clipboard": "\u94fe\u63a5\u5df2\u590d\u5236\u5230\u526a\u8d34\u677f",
    "Linked Devices": "\u5df2\u8fde\u63a5\u7684\u8bbe\u5907",
    "Links": "\u94fe\u63a5",
    "List": "\u5217\u8868",
    "List view": "\u5217\u8868\u89c6\u56fe",
    "List your account in global address book, so that others can find you by typing your name.": "\u5728\u901a\u8baf\u5f55\u4e2d\u5217\u51fa\u4f60\u7684\u8d26\u6237, \u4ee5\u4fbf\u5176\u4ed6\u4eba\u53ef\u4ee5\u901a\u8fc7\u8f93\u5165\u4f60\u7684\u540d\u5b57\u627e\u5230\u4f60\u3002",
    "Load all": "\u52a0\u8f7d\u5168\u90e8",
    "Loaded 50,000 records.": "\u5df2\u52a0\u8f7d 50000 \u884c\u8bb0\u5f55\u3002",
    "Loading": "\u52a0\u8f7d\u4e2d",
    "Location": "\u4f4d\u7f6e",
    "Lock": "\u9501\u5b9a",
    "Log out": "\u9000\u51fa",
    "Login": "\u767b\u5f55",
    "Login attempt limit": "\u767b\u5f55\u5c1d\u8bd5\u6b21\u6570\u9650\u5236",
    "Login background image": "\u767b\u5f55\u80cc\u666f\u56fe",
    "Logo": "\u6807\u5fd7",
    "Logo updated": "\u6807\u8bc6\u5df2\u66f4\u65b0",
    "Logs": "\u65e5\u5fd7",
    "Long text": "\u957f\u6587\u672c",
    "Manage group members": "\u7ba1\u7406\u7fa4\u7ec4\u6210\u5458",
    "Manage members": "\u7ba1\u7406\u6210\u5458",
    "Map": "\u5730\u56fe",
    "Mark all as read": "\u5168\u90e8\u6807\u8bb0\u4e3a\u5df2\u8bfb",
    "Mark all read": "\u5168\u90e8\u8bbe\u4e3a\u5df2\u8bfb",
    "Max": "\u6700\u5927\u503c",
    "Member": "\u7fa4\u7ec4\u6210\u5458",
    "Members": "\u6210\u5458",
    "Merge tags": "\u5408\u5e76\u6807\u7b7e",
    "Merge tags to:": "\u5408\u5e76\u6807\u7b7e\u5230\uff1a",
    "Message": "\u6d88\u606f",
    "Message (optional):": "\u9644\u52a0\u6d88\u606f\uff08\u53ef\u9009\uff09\uff1a",
    "Migrate User": "\u8fc1\u79fb\u7528\u6237",
    "Mobile": "\u79fb\u52a8\u5ba2\u6237\u7aef",
    "Modification Details": "\u4fee\u6539\u8be6\u60c5",
    "Modified": "\u4fee\u6539\u4e86",
    "Modified by": "\u4fee\u6539\u4eba",
    "Modified by:": "\u4fee\u6539\u4eba\uff1a",
    "Modified files": "\u4fee\u6539\u4e86\u7684\u6587\u4ef6",
    "Modifier": "\u4fee\u6539\u8005",
    "Modify": "\u4fee\u6539",
    "Modify includes modify file, move/rename file and folder": "\u4fee\u6539\u5305\u62ec\u4fee\u6539\u6587\u4ef6\uff0c\u79fb\u52a8/\u91cd\u547d\u540d\u6587\u4ef6\u548c\u76ee\u5f55",
    "Modify name": "\u66f4\u6539\u540d\u79f0",
    "Month": "\u6708",
    "Month:": "\u6708\u4efd:",
    "Monthly User Traffic": "\u7528\u6237\u6708\u6d41\u91cf",
    "More": "\u66f4\u591a",
    "More operations": "\u66f4\u591a\u64cd\u4f5c",
    "Move": "\u79fb\u52a8",
    "Move file": "\u79fb\u52a8\u6587\u4ef6",
    "Move folder": "\u79fb\u52a8\u76ee\u5f55",
    "Move selected item(s) to:": "\u5c06\u5df2\u9009\u6761\u76ee\u79fb\u52a8\u5230\uff1a",
    "Move {num} items": "\u79fb\u52a8 {num} \u4e2a\u6761\u76ee",
    "Move {placeholder} to": "\u79fb\u52a8 {placeholder} \u5230",
    "Moved file": "\u79fb\u52a8\u6587\u4ef6",
    "Moved folder": "\u79fb\u52a8\u76ee\u5f55",
    "Multiple select": "\u591a\u9009",
    "My Activities": "\u6211\u7684\u6d3b\u52a8",
    "My Libraries": "\u6211\u7684\u8d44\u6599\u5e93",
    "My Wikis": "\u6211\u7684\u77e5\u8bc6\u5e93",
    "Name": "\u540d\u79f0",
    "Name already exists": "\u540d\u79f0\u5df2\u7ecf\u5b58\u5728",
    "Name cannot be double dots": "\u540d\u79f0\u4e0d\u80fd\u662f\u4e24\u4e2a\u70b9",
    "Name cannot be empty": "\u540d\u79f0\u4e0d\u4e3a\u7a7a",
    "Name cannot contain backslash": "\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u53cd\u659c\u6760",
    "Name cannot contain backtick": "\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u53cd\u5f15\u53f7",
    "Name cannot contain curly braces": "\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u82b1\u62ec\u53f7",
    "Name cannot contain dots": "\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u70b9",
    "Name cannot contain slash": "\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u659c\u6760",
    "Name is required": "\u540d\u79f0\u4e3a\u5fc5\u586b\u9879",
    "Name is required.": "\u5fc5\u987b\u586b\u5199\u540d\u79f0\u3002",
    "Name or ID": "\u540d\u79f0\u6216 ID",
    "Name should be string": "\u540d\u79f0\u5fc5\u987b\u662f\u5b57\u7b26\u4e32",
    "Name should not include '/'.": "\u540d\u79f0\u4e0d\u80fd\u5305\u542b \u2018/\u2019\u3002",
    "Name updated": "\u540d\u79f0\u5df2\u66f4\u65b0",
    "Name(optional)": "\u540d\u79f0\uff08\u53ef\u9009\uff09",
    "Network error": "\u7f51\u7edc\u9519\u8bef",
    "New": "\u65b0\u5efa",
    "New Department": "\u65b0\u5efa\u90e8\u95e8",
    "New Department Library": "\u65b0\u5efa\u90e8\u95e8\u8d44\u6599\u5e93",
    "New Excel File": "\u65b0\u5efa Excel \u6587\u4ef6",
    "New File": "\u65b0\u5efa\u6587\u4ef6",
    "New Folder": "\u65b0\u5efa\u76ee\u5f55",
    "New Group": "\u65b0\u5efa\u7fa4\u7ec4",
    "New Library": "\u65b0\u5efa\u8d44\u6599\u5e93",
    "New Markdown File": "\u65b0\u5efa Markdown \u6587\u4ef6",
    "New Password": "\u65b0\u5bc6\u7801",
    "New Password Again": "\u518d\u6b21\u8f93\u5165\u65b0\u5bc6\u7801\uff1a",
    "New PowerPoint File": "\u65b0\u5efa PowerPoint \u6587\u4ef6",
    "New SeaDoc File": "\u65b0\u5efa SeaDoc \u6587\u4ef6",
    "New Sub-department": "\u65b0\u5efa\u5b50\u90e8\u95e8",
    "New Tag": "\u65b0\u5efa\u6807\u7b7e",
    "New Whiteboard File": "\u65b0\u5efa\u767d\u677f\u6587\u4ef6",
    "New Wiki name": "\u65b0\u5efa\u77e5\u8bc6\u5e93\u540d\u79f0",
    "New Word File": "\u65b0\u5efa Word \u6587\u4ef6",
    "New category": "\u65b0\u7c7b\u522b",
    "New child tag": "\u65b0\u5efa\u5b50\u6807\u7b7e",
    "New directories": "\u65b0\u76ee\u5f55",
    "New file name": "\u65b0\u7684\u6587\u4ef6\u540d\u79f0",
    "New files": "\u65b0\u6587\u4ef6",
    "New folder": "\u65b0\u5efa\u76ee\u5f55",
    "New folder name": "\u65b0\u7684\u76ee\u5f55\u540d\u79f0",
    "New page": "\u65b0\u5efa\u9875\u9762",
    "New password": "\u65b0\u5bc6\u7801",
    "New password cannot be the same as old password": "\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u65e7\u5bc6\u7801\u76f8\u540c",
    "New password has been sent to your email {mail}. Please check your mailbox. If you don\u2019t receive the password, please check if your email address is properly configured.": "\u65b0\u5bc6\u7801\u5df2\u53d1\u9001\u5230\u4f60\u7684\u7535\u5b50\u90ae\u4ef6{mail}\u3002 \u8bf7\u68c0\u67e5\u4f60\u7684\u90ae\u7bb1\u3002 \u5982\u679c\u4f60\u6ca1\u6709\u6536\u5230\u5bc6\u7801\uff0c\u8bf7\u68c0\u67e5\u4f60\u7684\u7535\u5b50\u90ae\u4ef6\u5730\u5740\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002",
    "New password is too short": "\u65b0\u5bc6\u7801\u592a\u77ed",
    "New passwords don't match": "\u4e24\u6b21\u8f93\u5165\u7684\u65b0\u5bc6\u7801\u4e0d\u4e00\u81f4",
    "New tag": "\u65b0\u6807\u7b7e",
    "New view": "\u65b0\u5efa\u89c6\u56fe",
    "Next": "\u4e0b\u4e00\u9875",
    "Next (Right arrow key)": "\u5411\u540e (\u53f3\u65b9\u5411\u952e)",
    "Next modification": "\u4e0b\u4e00\u4e2a\u4fee\u6539",
    "No Admin login logs": "\u8fd8\u6ca1\u6709\u7ba1\u7406\u5458\u767b\u5f55\u65e5\u5fd7",
    "No Admin operation logs": "\u8fd8\u6ca1\u6709\u7ba1\u7406\u5458\u64cd\u4f5c\u65e5\u5fd7",
    "No Wikis": "\u6ca1\u6709\u77e5\u8bc6\u5e93",
    "No address found for the given coordinates.": "\u627e\u4e0d\u5230\u7ed9\u5b9a\u5750\u6807\u7684\u5730\u5740\u3002",
    "No categories": "\u65e0\u7c7b\u522b",
    "No changes": "\u6ca1\u6709\u53d8\u5316",
    "No collaborators": "\u6ca1\u6709\u534f\u4f5c\u4eba",
    "No collaborators available": "\u6ca1\u6709\u53ef\u83b7\u53d6\u7684\u534f\u4f5c\u4eba",
    "No connected devices": "\u6ca1\u6709\u8fde\u63a5\u7684\u5ba2\u6237\u7aef",
    "No deleted libraries": "\u6ca1\u6709\u5df2\u5220\u9664\u7684\u8d44\u6599\u5e93",
    "No favorites": "\u6ca1\u6709\u6536\u85cf\u6761\u76ee",
    "No file": "\u6ca1\u6709\u6587\u4ef6",
    "No file access logs": "\u6ca1\u6709\u6587\u4ef6\u8bbf\u95ee\u65e5\u5fd7",
    "No file update logs": "\u6ca1\u6709\u6587\u4ef6\u66f4\u65b0\u65e5\u5fd7",
    "No files": "\u6ca1\u6709\u6587\u4ef6",
    "No filters": "\u6ca1\u6709\u8fc7\u6ee4\u6761\u4ef6",
    "No folders shared": "\u6ca1\u6709\u5171\u4eab\u76ee\u5f55",
    "No groupings applied to this view.": "\u6b64\u89c6\u56fe\u672a\u5e94\u7528\u4efb\u4f55\u5206\u7ec4\u3002",
    "No groups": "\u6ca1\u6709\u7fa4\u7ec4",
    "No guest invitations": "\u6ca1\u6709\u9080\u8bf7",
    "No invitations": "\u6ca1\u6709\u9080\u8bf7",
    "No libraries": "\u6ca1\u6709\u8d44\u6599\u5e93",
    "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.": "\u6ca1\u6709\u8d44\u6599\u5e93\u88ab\u76f4\u63a5\u5171\u4eab\u7ed9\u4f60\u3002\u4e00\u4e2a\u8d44\u6599\u5e93\u53ef\u4ee5\u4ee5\u5b8c\u5168\u7684\u6216\u53d7\u9650\u7684\u6743\u9650\u88ab\u5171\u4eab\u3002\u5982\u679c\u4f60\u9700\u8981\u8bbf\u95ee\u5176\u4ed6\u7528\u6237\u62e5\u6709\u7684\u4e00\u4e2a\u8d44\u6599\u5e93\uff0c\u4f60\u53ef\u4ee5\u8981\u6c42\u8fd9\u4e2a\u7528\u6237\u628a\u8fd9\u4e2a\u8d44\u6599\u5e93\u5171\u4eab\u7ed9\u4f60\u3002",
    "No libraries have been shared with this group yet. A library shared with a group can be accessed by all group members. You can share a library with a group in \"My Libraries\". You can also create a new library to be shared with this group by clicking the \"New Library\" item in the dropdown menu.": "\u5c1a\u672a\u4e0e\u6b64\u7fa4\u7ec4\u5171\u4eab\u4efb\u4f55\u8d44\u6599\u5e93\u3002\u6240\u6709\u7fa4\u7ec4\u6210\u5458\u90fd\u53ef\u4ee5\u8bbf\u95ee\u4e0e\u7fa4\u7ec4\u5171\u4eab\u7684\u8d44\u6599\u5e93\u3002\u4f60\u53ef\u4ee5\u5728\u201c\u6211\u7684\u8d44\u6599\u5e93\u201d\u4e2d\u4e0e\u7fa4\u7ec4\u5171\u4eab\u8d44\u6599\u5e93\u3002\u4f60\u8fd8\u53ef\u4ee5\u901a\u8fc7\u5355\u51fb\u4e0b\u62c9\u83dc\u5355\u4e2d\u7684\u201c\u65b0\u5efa\u8d44\u6599\u5e93\u201d\u9009\u9879\uff0c\u6765\u521b\u5efa\u8981\u4e0e\u6b64\u7fa4\u7ec4\u5171\u4eab\u7684\u65b0\u8d44\u6599\u5e93\u3002",
    "No libraries have been shared with you": "\u8fd8\u6ca1\u6709\u4efb\u4f55\u8d44\u6599\u5e93\u88ab\u5171\u4eab\u7ed9\u4f60",
    "No libraries have been shared with you from other servers.": "\u8fd8\u6ca1\u6709\u5171\u4eab\u81ea\u5176\u4ed6\u670d\u52a1\u5668\u7684\u8d44\u6599\u5e93\u3002",
    "No libraries shared": "\u6ca1\u6709\u5171\u4eab\u7684\u8d44\u6599\u5e93",
    "No libraries shared with this group": "\u6ca1\u6709\u8d44\u6599\u5e93\u88ab\u5171\u4eab\u5230\u5f53\u524d\u7fa4\u7ec4",
    "No linked devices": "\u6ca1\u6709\u8fde\u63a5\u7684\u8bbe\u5907",
    "No linked devices. You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "\u6ca1\u6709\u8fde\u63a5\u7684\u8bbe\u5907\u3002\u4f60\u5c1a\u672a\u4f7f\u7528\u4efb\u4f55\u5ba2\u6237\u7aef\uff08\u53f0\u5f0f\u673a\u6216\u79fb\u52a8\u8bbe\u5907\uff09\u8bbf\u95ee\u4f60\u7684\u6587\u4ef6\u3002\u5728\u4f60\u7684\u8bbe\u5907\u4e0a\u914d\u7f6e\u5ba2\u6237\u7aef\uff0c\u4ee5\u4fbf\u66f4\u8212\u9002\u5730\u8bbf\u95ee\u4f60\u7684\u6570\u636e\u3002",
    "No login logs": "\u6ca1\u6709\u767b\u5f55\u65e5\u5fd7",
    "No members": "\u6682\u65e0\u6210\u5458",
    "No more activities": " \u6ca1\u6709\u66f4\u591a\u6d3b\u52a8\u4e86",
    "No notifications": "\u6ca1\u6709\u901a\u77e5",
    "No option": "\u6ca1\u6709\u9009\u9879",
    "No options": "\u6ca1\u6709\u9009\u9879",
    "No options available": "\u6ca1\u6709\u53ef\u9009\u9009\u9879",
    "No permission logs": "\u6ca1\u6709\u6743\u9650\u65e5\u5fd7",
    "No preview": "\u6ca1\u6709\u9884\u89c8",
    "No properties available to be hidden": "\u6ca1\u6709\u53ef\u9690\u85cf\u7684\u5c5e\u6027",
    "No public libraries": "\u6ca1\u6709\u516c\u5171\u8d44\u6599\u5e93",
    "No public libraries have been created yet. A public library is accessible by all users. You can create a public library by clicking the \"Add Library\" item in the dropdown menu.": "\u5c1a\u672a\u521b\u5efa\u516c\u5171\u8d44\u6599\u5e93\u3002\u516c\u5171\u8d44\u6599\u5e93\u5bf9\u6240\u6709\u7528\u6237\u5f00\u653e\u3002\u4f60\u53ef\u4ee5\u901a\u8fc7\u5355\u51fb\u4e0b\u62c9\u83dc\u5355\u4e2d\u7684\u201c\u6dfb\u52a0\u8d44\u6599\u5e93\u201d\u9009\u9879\u6765\u521b\u5efa\u516c\u5171\u8d44\u6599\u5e93\u3002",
    "No record": "\u6ca1\u6709\u8bb0\u5f55",
    "No result": "\u6ca1\u6709\u7ed3\u679c",
    "No results": "\u6ca1\u6709\u7ed3\u679c",
    "No results matching": "\u6ca1\u6709\u5339\u914d\u7684\u7ed3\u679c",
    "No share links": "\u6ca1\u6709\u5171\u4eab\u5916\u94fe",
    "No shared libraries": "\u6ca1\u6709\u5171\u4eab\u7684\u8d44\u6599\u5e93",
    "No sorts": "\u6ca1\u6709\u6392\u5e8f",
    "No sync errors": "\u6ca1\u6709\u540c\u6b65\u9519\u8bef",
    "No tag": "\u6ca1\u6709\u6807\u7b7e",
    "No tags": "\u6ca1\u6709\u6807\u7b7e",
    "No tags available": "\u6ca1\u6709\u53ef\u83b7\u53d6\u7684\u6807\u7b7e",
    "No terms and conditions": "\u6ca1\u6709\u6761\u6b3e",
    "No upload links": "\u6ca1\u6709\u4e0a\u4f20\u5916\u94fe",
    "No users": "\u6ca1\u6709\u7528\u6237",
    "No version history": "\u6ca1\u6709\u7248\u672c\u5386\u53f2",
    "None": "\u65e0",
    "Not allow user to clean library trash": "\u4e0d\u5141\u8bb8\u7528\u6237\u6e05\u7a7a\u8d44\u6599\u5e93\u56de\u6536\u7ad9",
    "Not allow user to create encrypted libraries": "\u4e0d\u5141\u8bb8\u7528\u6237\u521b\u5efa\u52a0\u5bc6\u8d44\u6599\u5e93",
    "Note: Settings via web interface are saved in database table (seahub-db/constance_config). They have a higher priority over the settings in config files.": "\u6ce8\u610f\uff1a\u901a\u8fc7 Web \u754c\u9762\u8bbe\u7f6e\u7684\u9009\u9879\u4f1a\u4fdd\u5b58\u5728\u6570\u636e\u5e93 (seahub-db/constance_config) \u4e2d\u3002\u4ed6\u4eec\u6bd4\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u8bbe\u7f6e\u6709\u66f4\u9ad8\u7684\u4f18\u5148\u7ea7\u3002",
    "Notification": "\u901a\u77e5",
    "Notification Detail": "\u901a\u77e5\u5185\u5bb9",
    "Notifications": "\u901a\u77e5",
    "Notifications of collaboration": "\u534f\u4f5c\u901a\u77e5",
    "Notifications of file changes": "\u6587\u4ef6\u6539\u52a8\u901a\u77e5",
    "Number": "\u6570\u5b57",
    "Number of days ago": "\u7279\u5b9a\u5929\u6570\u524d",
    "Number of days from now": "\u7279\u5b9a\u5929\u6570\u540e",
    "Number of days that keep user sign in.": "\u8bb0\u4f4f\u7528\u6237\u5df2\u767b\u5f55\u72b6\u6001\u7684\u5929\u6570\u3002",
    "Number of groups": "\u7fa4\u7ec4\u6570\u91cf",
    "Number of links": "\u94fe\u63a5\u6570\u91cf",
    "OCR": "OCR",
    "OCR result": "OCR \u7ed3\u679c",
    "Off": "\u5173\u95ed",
    "Office Suite": "\u529e\u516c\u5957\u4ef6",
    "Old Password": "\u65e7\u5bc6\u7801",
    "Old Wikis": "\u65e7\u7248\u77e5\u8bc6\u5e93",
    "On": "\u5f00\u542f",
    "One month ago": "\u4e00\u4e2a\u6708\u524d",
    "One month from now": "\u4e00\u4e2a\u6708\u540e",
    "One week ago": "\u4e00\u5468\u524d",
    "One week from now": "\u4e00\u5468\u540e",
    "Online Preview": "\u5728\u7ebf\u9884\u89c8",
    "Online Read-Only": "\u4ec5\u4e91\u7aef\u9884\u89c8",
    "Online Read-Only folder": "\u4ec5\u4e91\u7aef\u9884\u89c8\u76ee\u5f55",
    "Online Read-Only library": "\u4ec5\u4e91\u7aef\u9884\u89c8\u8d44\u6599\u5e93",
    "Online Read-Write": "\u4ec5\u4e91\u7aef\u8bfb\u5199",
    "Online Read-Write folder": "\u4ec5\u4e91\u7aef\u8bfb\u5199\u76ee\u5f55",
    "Online Read-Write library": "\u4ec5\u4e91\u7aef\u8bfb\u5199\u8d44\u6599\u5e93",
    "Online view is not applicable to this file format": "\u6b64\u6587\u4ef6\u683c\u5f0f\u4e0d\u652f\u6301\u4e91\u7aef\u67e5\u770b",
    "Only Show": "\u53ea\u663e\u793a",
    "Only files": "\u4ec5\u6587\u4ef6",
    "Only folders": "\u4ec5\u76ee\u5f55",
    "Only keep a period of history:": "\u4ec5\u4fdd\u7559\u4e00\u6bb5\u65f6\u95f4\u7684\u5386\u53f2:",
    "Only pictures": "\u53ea\u6709\u56fe\u7247",
    "Only videos": "\u53ea\u6709\u89c6\u9891",
    "Open file in new tab": "\u5728\u65b0\u6807\u7b7e\u4e2d\u6253\u5f00\u6587\u4ef6",
    "Open folder in new tab": "\u5728\u65b0\u6807\u7b7e\u4e2d\u6253\u5f00\u76ee\u5f55",
    "Open in new tab": "\u65b0\u6807\u7b7e\u4e2d\u6253\u5f00",
    "Open parent folder": "\u6253\u5f00\u7236\u76ee\u5f55",
    "Open via Client": "\u5ba2\u6237\u7aef\u6253\u5f00",
    "Operation": "\u64cd\u4f5c",
    "Operation succeeded.": "\u64cd\u4f5c\u6210\u529f",
    "Operations": "\u64cd\u4f5c",
    "Optional": "\u53ef\u9009",
    "Options imported": "\u9009\u9879\u5df2\u5bfc\u5165",
    "Or": "\u6216\u8005",
    "Organization": "\u516c\u5171",
    "Organization Admin": "\u56e2\u961f\u7ba1\u7406",
    "Organizations": "\u56e2\u961f",
    "Original path": "\u539f\u8def\u5f84",
    "Other": "\u5176\u4ed6",
    "Other Libraries": "\u5176\u4ed6\u8d44\u6599\u5e93",
    "Others": "\u5176\u4ed6",
    "Out of quota.": "\u7a7a\u95f4\u5df2\u8d85",
    "Outdated": "\u5df2\u8fc7\u671f",
    "Owned Libraries": "\u62e5\u6709\u7684\u8d44\u6599\u5e93",
    "Owner": "\u62e5\u6709\u8005",
    "Owner can use admin panel in an organization, must be a new account.": "\u62e5\u6709\u8005\u80fd\u4f7f\u7528\u56e2\u961f\u7684\u7ba1\u7406\u5458\u9762\u677f, \u5fc5\u987b\u662f\u4e00\u4e2a\u65b0\u7684\u8d26\u53f7\u3002",
    "Packaging...": "\u6b63\u5728\u6253\u5305",
    "Page name": "\u9875\u9762\u540d\u79f0",
    "Page {name_placeholder} deleted.": "\u9875\u9762 {name_placeholder} \u5df2\u5220\u9664\u3002",
    "Pages": "\u9875\u9762",
    "Parent folder": "\u7236\u76ee\u5f55",
    "Parent tags": "\u7236\u6807\u7b7e",
    "Password": "\u5bc6\u7801",
    "Password again": "\u8bf7\u518d\u6b21\u8f93\u5165\u5bc6\u7801",
    "Password cannot be blank": "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a",
    "Password is too short": "\u5bc6\u7801\u592a\u77ed",
    "Password must be at least 8 characters long and contain different characters: uppercase letters, lowercase letters, numbers, and special symbols": "\u5bc6\u7801\u957f\u5ea6\u5fc5\u987b\u81f3\u5c11\u4e3a8\u4e2a\u5b57\u7b26\uff0c\u5e76\u4e14\u5305\u542b\u4e0d\u540c\u7684\u5b57\u7b26\uff1a\u5927\u5199\u5b57\u6bcd\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u7279\u6b8a\u7b26\u53f7",
    "Password removed": "\u5bc6\u7801\u5df2\u79fb\u9664",
    "Password reset": "\u5bc6\u7801\u5df2\u91cd\u7f6e",
    "Password set": "\u5bc6\u7801\u5df2\u8bbe\u7f6e",
    "Password strength": "\u5bc6\u7801\u5f3a\u5ea6",
    "Password strength should be strong or very strong": "\u5bc6\u7801\u5f3a\u5ea6\u5e94\u8be5\u662f\u5f3a\u6216\u975e\u5e38\u5f3a",
    "Password updated": "\u5bc6\u7801\u5df2\u66f4\u65b0",
    "Passwords do not match.": "\u5bc6\u7801\u4e0d\u5339\u914d\u3002",
    "Passwords don't match": "\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4",
    "Path": "\u6587\u4ef6\u8def\u5f84",
    "People": "\u4eba\u50cf",
    "Per 4 hours": "\u6bcf4\u5c0f\u65f6",
    "Per day": "\u6bcf\u5929",
    "Per hour": "\u6bcf\u5c0f\u65f6",
    "Per week": "\u6bcf\u5468",
    "Permission": "\u6743\u9650",
    "Permission denied": "\u6ca1\u6709\u6743\u9650",
    "Permission denied. Please try {placeholder-left}login again.{placeholder-right}": "\u6743\u9650\u9519\u8bef\u3002\u8bf7\u5c1d\u8bd5 {placeholder-left}\u91cd\u65b0\u767b\u5f55\u3002{placeholder-right}",
    "Permission name": "\u6743\u9650\u540d\u79f0",
    "Person image": "\u4eba\u50cf\u7167\u7247",
    "Picture": "\u56fe\u7247",
    "Pictures and videos": "\u56fe\u7247\u548c\u89c6\u9891",
    "Platform": "\u5e73\u53f0",
    "Please check the network.": "\u8bf7\u68c0\u67e5\u7f51\u7edc\u662f\u5426\u5df2\u8fde\u63a5\u3002",
    "Please choose a .sdoczip file.": "\u8bf7\u9009\u62e9\u4e00\u4e2a.sdoczip \u6587\u4ef6\u3002",
    "Please choose a .xlsx file.": "\u8bf7\u9009\u62e9.xlsx\u540e\u7f00\u6587\u4ef6",
    "Please choose an image file.": "\u8bf7\u9009\u62e9\u4e00\u4e2a\u56fe\u7247\u6587\u4ef6\u3002",
    "Please enter 1 or more character": "\u8bf7\u8f93\u5165 1 \u4e2a\u6216\u66f4\u591a\u5b57\u7b26",
    "Please enter a new password": "\u8bf7\u8f93\u5165\u65b0\u5bc6\u7801\u3002",
    "Please enter a new quota": "\u8bf7\u8f93\u5165\u4e00\u4e2a\u65b0\u7684\u914d\u989d",
    "Please enter a non-negative integer": "\u8bf7\u8f93\u5165\u4e00\u4e2a\u975e\u8d1f\u6574\u6570",
    "Please enter a password.": "\u8bf7\u8f93\u5165\u5bc6\u7801\u3002",
    "Please enter a positive integer": "\u8bf7\u8f93\u5165\u4e00\u4e2a\u6b63\u6574\u6570",
    "Please enter an integer bigger than 1 as number of links.": "\u8bf7\u8f93\u5165\u4e00\u4e2a\u5927\u4e8e 1 \u7684\u6574\u6570\u4f5c\u4e3a\u94fe\u63a5\u6570\u91cf\u3002",
    "Please enter an integer not bigger than {max_number} as number of links.": "\u8bf7\u8f93\u5165\u4e00\u4e2a\u4e0d\u5927\u4e8e {max_number} \u7684\u6574\u6570\u4f5c\u4e3a\u94fe\u63a5\u6570\u91cf\u3002",
    "Please enter days": "\u8bf7\u8f93\u5165\u5929\u6570",
    "Please enter password": "\u8bf7\u8f93\u5165\u5bc6\u7801",
    "Please enter the new password again": "\u8bf7\u518d\u6b21\u8f93\u5165\u65b0\u5bc6\u7801",
    "Please enter the old password": "\u8bf7\u8f93\u5165\u65e7\u5bc6\u7801\u3002",
    "Please enter the password again": "\u8bf7\u518d\u6b21\u8f93\u5165\u5bc6\u7801",
    "Please input at least an email.": "\u8bf7\u8f93\u5165\u81f3\u5c11\u4e00\u4e2a\u90ae\u7bb1\u3002",
    "Please select a file": "\u8bf7\u9009\u62e9\u4e00\u4e2a\u6587\u4ef6",
    "Please select a library or folder first.": "\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u8d44\u6599\u5e93\u6216\u76ee\u5f55\u3002",
    "Please select a library to share.": "\u8bf7\u9009\u62e9\u4e00\u4e2a\u8d44\u6599\u5e93\u6765\u5171\u4eab\u3002",
    "Please select an expiration time": "\u8bf7\u9009\u62e9\u8fc7\u671f\u65f6\u95f4\u3002",
    "Please upload no more than {maxFiles} files at a time.": "\u4e00\u6b21\u6700\u591a\u4e0a\u4f20  {maxFiles} \u4e2a\u6587\u4ef6\u3002",
    "Predefined properties": "\u9884\u5b9a\u4e49\u5c5e\u6027",
    "Preparing to upload...": "\u51c6\u5907\u4e0a\u4f20...",
    "Preset hide properties": "\u9884\u9690\u85cf\u5c5e\u6027",
    "Preview and download": "\u9884\u89c8\u4e0e\u4e0b\u8f7d",
    "Preview online": "\u5728\u7ebf\u9884\u89c8",
    "Preview only": "\u4ec5\u67e5\u770b",
    "Previous": "\u524d\u4e00\u9875",
    "Previous (Left arrow key)": "\u5411\u524d (\u5de6\u65b9\u5411\u952e)",
    "Print": "\u6253\u5370",
    "Print document": "\u6253\u5370\u6587\u6863",
    "Professional Edition": "\u4f01\u4e1a\u7248",
    "Profile": "\u4e2a\u4eba\u4fe1\u606f",
    "Profile Setting": "\u4e2a\u4eba\u4fe1\u606f\u8bbe\u7f6e",
    "Properties": "\u5c5e\u6027",
    "Properties to display on the card": "\u5728\u5361\u7247\u4e0a\u663e\u793a\u7684\u5c5e\u6027",
    "Property name": "\u5c5e\u6027\u540d",
    "Publish": "\u53d1\u5e03",
    "Publish Wiki": "\u53d1\u5e03\u77e5\u8bc6\u5e93",
    "Published": "\u5df2\u53d1\u5e03",
    "Quota": "\u914d\u989d",
    "Quota is invalid.": "\u914d\u989d\u65e0\u6548\u3002",
    "Rate": "\u8bc4\u5206",
    "Read-Only": "\u53ea\u8bfb",
    "Read-Only folder": "\u53ea\u8bfb\u76ee\u5f55",
    "Read-Only library": "\u53ea\u8bfb\u8d44\u6599\u5e93",
    "Read-Write": "\u53ef\u8bfb\u5199",
    "Read-Write folder": "\u53ef\u8bfb\u5199\u76ee\u5f55",
    "Read-Write library": "\u53ef\u8bfb\u5199\u8d44\u6599\u5e93",
    "Really want to delete this group?": "\u786e\u5b9a\u8981\u5220\u9664\u8fd9\u4e2a\u7fa4\u7ec4\uff1f",
    "Really want to delete your account?": "\u786e\u5b9a\u8981\u6ce8\u9500\u8be5\u8d26\u53f7\u5417\uff1f",
    "Really want to leave this group?": "\u786e\u5b9a\u8981\u9000\u51fa\u8fd9\u4e2a\u7fa4\u7ec4\uff1f",
    "Recently Used": "\u6700\u8fd1\u4f7f\u7528",
    "Recognizing portraits. Please refresh the page later.": "\u8bc6\u522b\u4eba\u50cf\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u9875\u9762\u3002",
    "Refresh": "\u5237\u65b0",
    "Refresh the view": "\u5237\u65b0\u89c6\u56fe",
    "Remaining": "\u5269\u4f59",
    "Remove": "\u5220\u9664",
    "Remove Member": "\u79fb\u9664\u6210\u5458",
    "Remove from this group": "\u4ece\u8fd9\u4e2a\u7ec4\u4e2d\u5220\u9664",
    "Removed all items from trash.": "\u5220\u9664\u4e86\u56de\u6536\u7ad9\u4e2d\u7684\u6240\u6709\u6761\u76ee.",
    "Removed items older than {n} days from trash.": "\u5220\u9664\u4e86\u56de\u6536\u7ad9\u4e2d{n}\u5929\u524d\u7684\u6761\u76ee.",
    "Rename": "\u91cd\u547d\u540d",
    "Rename Department": "\u91cd\u547d\u540d\u90e8\u95e8",
    "Rename File": "\u91cd\u547d\u540d\u6587\u4ef6",
    "Rename Folder": "\u91cd\u547d\u540d\u76ee\u5f55",
    "Rename Group": "\u91cd\u547d\u540d\u7fa4\u7ec4",
    "Rename Wiki": "\u91cd\u547d\u540d\u77e5\u8bc6\u5e93",
    "Rename file": "\u91cd\u547d\u540d\u6587\u4ef6",
    "Rename folder": "\u91cd\u547d\u540d\u6587\u4ef6\u5939",
    "Rename group to": "\u91cd\u547d\u540d\u7fa4\u7ec4\u4e3a",
    "Rename property": "\u91cd\u547d\u540d\u5c5e\u6027",
    "Renamed file": "\u91cd\u547d\u540d\u6587\u4ef6",
    "Renamed folder": "\u91cd\u547d\u540d\u76ee\u5f55",
    "Renamed library": "\u91cd\u547d\u540d\u8d44\u6599\u5e93",
    "Renamed or Moved files": "\u91cd\u547d\u540d\u6216\u79fb\u52a8\u7684\u6587\u4ef6",
    "Renaming {name} failed": "\u91cd\u547d\u540d{name}\u5931\u8d25",
    "Replace": "\u66ff\u6362",
    "Replace file {filename}?": "\u8986\u76d6\u6587\u4ef6 {filename} \uff1f",
    "Replacing it will overwrite its content.": "\u66ff\u6362\u5b83\u4f1a\u8986\u76d6\u5df2\u6709\u5185\u5bb9\u3002",
    "Report Abuse": "\u4e3e\u62a5",
    "Reporter": "\u4e3e\u62a5\u8005",
    "Reports": "\u7edf\u8ba1\u62a5\u8868",
    "Required at least three letters.": "\u81f3\u5c11\u9700\u8981\u4e09\u4e2a\u5b57\u6bcd\u3002",
    "Reset": "\u91cd\u7f6e",
    "Reset Password": "\u91cd\u7f6e\u5bc6\u7801",
    "Reset WebDAV Password": "\u91cd\u7f6e WebDAV \u5bc6\u7801",
    "Reset library password": "\u91cd\u7f6e\u8d44\u6599\u5e93\u5bc6\u7801",
    "ResetPwd": "\u91cd\u7f6e\u5bc6\u7801",
    "Resetting user's password, please wait for a moment.": "\u91cd\u7f6e\u7528\u6237\u5bc6\u7801\uff0c\u8bf7\u7a0d\u7b49\u3002",
    "Restore": "\u8fd8\u539f",
    "Restore Library": "\u8fd8\u539f\u8d44\u6599\u5e93",
    "Restored 1 item": "\u5df2\u6062\u590d1\u4e2a\u9879\u76ee",
    "Restored file": "\u6062\u590d\u6587\u4ef6",
    "Restored folder": "\u6062\u590d\u76ee\u5f55",
    "Restored library": "\u6062\u590d\u8d44\u6599\u5e93",
    "Restored {name}": "\u6062\u590d\u4e86 {name}",
    "Restored {name} and {n} other items": "\u6062\u590d\u4e86 {name} \u548c {n} \u4e2a\u5176\u4ed6\u6761\u76ee",
    "Result": "\u641c\u7d22\u7ed3\u679c",
    "Retry": "\u91cd\u65b0\u4e0a\u4f20",
    "Retry All": "\u91cd\u4f20\u6240\u6709\u5931\u8d25\u9879",
    "Revoke": "\u64a4\u9500",
    "Revoke Access": "\u64a4\u6d88\u8bbf\u95ee\u6743\u9650",
    "Revoke Admin": "\u64a4\u9500\u7ba1\u7406\u6743\u9650",
    "Role": "\u7528\u6237\u89d2\u8272",
    "Rotate": "\u65cb\u8f6c",
    "SAML config": "SAML \u914d\u7f6e",
    "SAML config updated": "SAML \u914d\u7f6e\u5df2\u66f4\u65b0",
    "Satellite": "\u536b\u661f",
    "Save": "\u4fdd\u5b58",
    "Save Selected Items": "\u4fdd\u5b58\u9009\u62e9\u7684\u6761\u76ee",
    "Save as ...": "\u53e6\u5b58\u4e3a...",
    "Save to:": "\u6587\u4ef6\u53e6\u5b58\u4e3a:",
    "Saving...": "\u4fdd\u5b58\u4e2d...",
    "Scan the QR code to view the shared content directly": "\u626b\u7801\u76f4\u63a5\u67e5\u770b\u5171\u4eab\u7684\u5185\u5bb9",
    "SeaTable integration": "SeaTable \u96c6\u6210",
    "Seafile": "\u6d77\u6587\u4e92\u77e5",
    "Search": "\u641c\u7d22",
    "Search Groups": "\u641c\u7d22\u7fa4\u7ec4",
    "Search Libraries": "\u641c\u7d22\u8d44\u6599\u5e93",
    "Search Organizations": "\u641c\u7d22\u56e2\u961f",
    "Search Users": "\u641c\u7d22\u7528\u6237",
    "Search collaborator": "\u67e5\u627e\u534f\u4f5c\u4eba",
    "Search collaborators": "\u641c\u7d22\u534f\u4f5c\u4eba",
    "Search files": "\u641c\u7d22\u6587\u4ef6",
    "Search files in this library": "\u5728\u5f53\u524d\u8d44\u6599\u5e93\u641c\u7d22\u6587\u4ef6",
    "Search group members": "\u641c\u7d22\u7fa4\u7ec4\u6210\u5458",
    "Search groups": "\u67e5\u627e\u7fa4\u7ec4",
    "Search groups by name": "\u6839\u636e\u540d\u79f0\u641c\u7d22\u7fa4\u7ec4",
    "Search libraries by name or ID": "\u6839\u636e\u540d\u79f0\u6216 ID \u641c\u7d22\u8d44\u6599\u5e93",
    "Search libraries by owner": "\u6839\u636e\u62e5\u6709\u8005\u641c\u7d22\u8d44\u6599\u5e93",
    "Search option": "\u9009\u62e9\u6807\u7b7e",
    "Search organizations": "\u641c\u7d22\u56e2\u961f",
    "Search property": "\u641c\u7d22\u5c5e\u6027",
    "Search property types": "\u641c\u7d22\u5c5e\u6027\u7c7b\u578b",
    "Search results visited recently": "\u6700\u8fd1\u8bbf\u95ee\u7684\u641c\u7d22\u7ed3\u679c",
    "Search tag": "\u641c\u7d22\u6807\u7b7e",
    "Search users": "\u641c\u7d22\u7528\u6237",
    "Search users...": "\u641c\u7d22\u7528\u6237...",
    "Select": "\u9009\u62e9",
    "Select All": "\u9009\u62e9\u5168\u90e8",
    "Select File": "\u9009\u62e9\u6587\u4ef6",
    "Select Image": "\u9009\u62e9\u56fe\u7247",
    "Select Tags": "\u9009\u62e9\u6807\u7b7e",
    "Select a color": "\u9009\u62e9\u4e00\u4e2a\u989c\u8272",
    "Select a department": "\u9009\u62e9\u4e00\u4e2a\u90e8\u95e8",
    "Select a office suite": "\u9009\u62e9\u4e00\u4e2a\u529e\u516c\u5957\u4ef6",
    "Select a server": "\u9009\u62e9\u4e00\u4e2a\u670d\u52a1\u5668",
    "Select a user": "\u9009\u62e9\u4e00\u4e2a\u7528\u6237",
    "Select a user as admin": "\u9009\u62e9\u4e00\u4e2a\u7528\u6237\u4f5c\u4e3a\u7ba1\u7406\u5458",
    "Select all": "\u9009\u62e9\u5168\u90e8",
    "Select all items": "\u9009\u62e9\u6240\u6709\u6761\u76ee",
    "Select an option": "\u9009\u62e9\u6807\u7b7e",
    "Select collaborators": "\u9009\u62e9\u534f\u4f5c\u4eba",
    "Select group members": "\u9009\u62e9\u7fa4\u7ec4\u6210\u5458",
    "Select libraries to share": "\u9009\u62e9\u8981\u5171\u4eab\u7684\u8d44\u6599\u5e93",
    "Select option(s)": "\u9009\u62e9\u6807\u7b7e",
    "Select shared users": "\u9009\u62e9\u5171\u4eab\u7528\u6237",
    "Select this item": "\u9009\u62e9\u8be5\u6761\u76ee",
    "Select up to 50 files": "\u6700\u591a\u9009\u62e950\u4e2a\u6587\u4ef6",
    "Selected": "\u5df2\u9009\u62e9",
    "Send": "\u53d1\u9001",
    "Send activation Email after user registration.": "\u7528\u6237\u6ce8\u518c\u540e\u53d1\u9001\u6fc0\u6d3b\u90ae\u4ef6\u3002",
    "Send activation email": "\u53d1\u9001\u6fc0\u6d3b\u90ae\u4ef6",
    "Send to:": "\u53d1\u9001\u5230\uff1a",
    "Sending new password...": "\u6b63\u5728\u53d1\u9001\u65b0\u5bc6\u7801...",
    "Sending...": "\u53d1\u9001\u4e2d...",
    "Server": "\u670d\u52a1\u5668",
    "Server Version: ": "\u670d\u52a1\u5668\u7248\u672c\uff1a",
    "Set": "\u8bbe\u7f6e",
    "Set Admin": "\u8bbe\u4e3a\u7ba1\u7406\u5458",
    "Set Contact Email": "\u8bbe\u7f6e\u8054\u7cfb\u90ae\u7bb1",
    "Set Download Rate Limit": "\u8bbe\u7f6e\u4e0b\u8f7d\u901f\u7387\u6700\u5927\u503c",
    "Set Login ID": "\u8bbe\u7f6e\u767b\u5f55 ID",
    "Set Name": "\u8bbe\u7f6e\u540d\u79f0",
    "Set Password": "\u8bbe\u7f6e\u5bc6\u7801",
    "Set Quota": "\u8bbe\u7f6e\u914d\u989d",
    "Set Upload Rate Limit": "\u8bbe\u7f6e\u4e0a\u4f20\u901f\u7387\u6700\u5927\u503c",
    "Set WebDAV Password": "\u8bbe\u7f6e WebDAV \u5bc6\u7801",
    "Set access scope": "\u8bbe\u7f6e\u8bbf\u95ee\u8303\u56f4",
    "Set as cover photo": "\u8bbe\u7f6e\u4e3a\u5c01\u9762\u7167\u7247",
    "Set child tags": "\u8bbe\u7f6e\u5b50\u6807\u7b7e",
    "Set max number of members": "\u8bbe\u7f6e\u6700\u5927\u6210\u5458\u6570",
    "Set password": "\u8bbe\u7f6e\u5bc6\u7801",
    "Set permission": "\u8bbe\u7f6e\u6743\u9650",
    "Set permission of {placeholder}": "\u8bbe\u7f6e {placeholder} \u7684\u6743\u9650",
    "Set quota": "\u8bbe\u7f6e\u5bb9\u91cf",
    "Set to current": "\u8bbe\u4e3a\u5f53\u524d\u901a\u77e5",
    "Set user contact email": "\u8bbe\u7f6e\u7528\u6237\u7684\u8054\u7cfb\u90ae\u7bb1",
    "Set user default quota": "\u8bbe\u7f6e\u7528\u6237\u9ed8\u8ba4\u914d\u989d",
    "Set user inactive": "\u5c06\u7528\u6237\u8bbe\u7f6e\u4e3a\u201c\u672a\u6fc0\u6d3b\u201d",
    "Set user name": "\u8bbe\u7f6e\u7528\u6237\u540d\u5b57",
    "Set user quota": "\u8bbe\u7f6e\u7528\u6237\u5bb9\u91cf",
    "Setting library history is disabled by Admin.": "\u8d44\u6599\u5e93\u5386\u53f2\u8bbe\u7f6e\u5df2\u88ab\u7ba1\u7406\u5458\u7981\u7528\u3002",
    "Setting updated": "\u8bbe\u7f6e\u5df2\u66f4\u65b0",
    "Settings": "\u8bbe\u7f6e",
    "Share": "\u5171\u4eab",
    "Share Admin": "\u5171\u4eab\u7ba1\u7406",
    "Share From": "\u5171\u4eab\u6765\u6e90",
    "Share Link": "\u5171\u4eab\u94fe\u63a5",
    "Share Link Traffic": "\u5916\u94fe\u6d41\u91cf",
    "Share Links": "\u5171\u4eab\u94fe\u63a5",
    "Share To": "\u5171\u4eab\u7ed9",
    "Share To:": "\u5171\u4eab\u7ed9\uff1a",
    "Share existing libraries": "\u5171\u4eab\u5df2\u6709\u8d44\u6599\u5e93 ",
    "Share link download": "\u5171\u4eab\u94fe\u63a5\u4e0b\u8f7d",
    "Share link is copied to the clipboard.": "\u5171\u4eab\u94fe\u63a5\u5df2\u590d\u5236\u5230\u526a\u8d34\u677f\u3002",
    "Share link upload": "\u5171\u4eab\u94fe\u63a5\u4e0a\u4f20",
    "Share links cannot be generated because \"Invisible\", \"Online Read-Write\" or \"Online Read-Only\" is set for you on some folder(s) in the library.": "\u4e0d\u80fd\u751f\u6210\u5171\u4eab\u94fe\u63a5\uff0c\u56e0\u4e3a\u8be5\u8d44\u6599\u5e93\u4e2d\u6709\u76ee\u5f55\u5bf9\u4f60\u8bbe\u7f6e\u4e86\u201c\u4e0d\u53ef\u89c1\u201d\uff0c\u201c\u4ec5\u4e91\u7aef\u8bfb\u5199\u201d\u6216\u201c\u4ec5\u4e91\u7aef\u53ea\u8bfb\u201d\u3002",
    "Share to group": "\u5171\u4eab\u7ed9\u7fa4\u7ec4",
    "Share to other server": "\u5171\u4eab\u5230\u5176\u4ed6\u670d\u52a1\u5668",
    "Share to user": "\u5171\u4eab\u7ed9\u7528\u6237",
    "Share/upload link force password": "\u5206\u4eab/\u4e0a\u4f20\u94fe\u63a5\u5f3a\u5236\u5bc6\u7801",
    "Share/upload link password minimum length": "\u5171\u4eab/\u4e0a\u4f20\u94fe\u63a5\u5bc6\u7801\u6700\u5c0f\u957f\u5ea6",
    "Share/upload link password strength level": "\u5171\u4eab/\u4e0a\u4f20\u94fe\u63a5\u5bc6\u7801\u5f3a\u5ea6\u7ea7\u522b",
    "Shared By": "\u5171\u4eab\u6765\u6e90",
    "Shared Libraries": "\u5171\u4eab\u7684\u8d44\u6599\u5e93",
    "Shared Links": "\u5171\u4eab\u94fe\u63a5",
    "Shared by:": "\u5171\u4eab\u6765\u6e90\uff1a",
    "Shared by: ": "\u5171\u4eab\u6765\u6e90\uff1a",
    "Shared with all": "\u516c\u5171\u8d44\u6599\u5e93",
    "Shared with me": "\u5171\u4eab\u7ed9\u6211\u7684",
    "Show": "\u663e\u793a",
    "Show Codes": "\u663e\u793a\u9a8c\u8bc1\u7801",
    "Show all": "\u663e\u793a\u5168\u90e8",
    "Show changes": "\u663e\u793a\u4fee\u6539",
    "Show property names": "\u663e\u793a\u5c5e\u6027\u540d\u79f0",
    "Side Nav Menu": "\u4fa7\u8fb9\u5bfc\u822a\u83dc\u5355",
    "Single select": "\u5355\u9009",
    "Site name": "\u7f51\u7ad9\u540d\u79f0",
    "Site name used in email sending": "\u53d1\u9001\u90ae\u4ef6\u65f6\u663e\u793a\u7684\u7f51\u7ad9\u540d\u79f0\u3002",
    "Site title": "\u7f51\u7ad9\u6807\u9898",
    "Site title shown in a browser tab": "\u7f51\u7ad9\u6807\u9898\uff0c\u663e\u793a\u5728\u6d4f\u89c8\u5668 tab \u4e2d\u3002",
    "Size": "\u5927\u5c0f",
    "Social Login": "\u793e\u4ea4\u8d26\u53f7\u767b\u5f55",
    "Sort": "\u6392\u5e8f",
    "Sort ascending": "\u5347\u5e8f\u6392\u5e8f",
    "Sort descending": "\u964d\u5e8f\u6392\u5e8f",
    "Space Used": "\u5df2\u7528\u7a7a\u95f4",
    "Space Used / Quota": "\u5df2\u7528\u7a7a\u95f4 / \u5bb9\u91cf ",
    "Space used": "\u5df2\u4f7f\u7528\u7a7a\u95f4",
    "Specific people with email address": "\u62e5\u6709\u6307\u5b9a\u90ae\u7bb1\u7684\u4eba",
    "Specific users in the team": "\u56e2\u961f\u4e2d\u7684\u7279\u5b9a\u7528\u6237",
    "Star": "\u6dfb\u52a0\u661f\u6807",
    "Start date": "\u8d77\u59cb\u65e5\u671f",
    "Statistic": "\u7edf\u8ba1",
    "Status": "\u72b6\u6001",
    "Status: enabled": "\u72b6\u6001\uff1a\u5df2\u542f\u7528",
    "Storage": "\u5df2\u7528\u7a7a\u95f4",
    "Storage Backend": "\u5b58\u50a8\u540e\u7aef",
    "Storage Used": "\u5df2\u7528\u7a7a\u95f4",
    "Strong password": "\u5f3a\u5bc6\u7801",
    "Style": "\u6837\u5f0f",
    "Submit": "\u63d0\u4ea4",
    "Success": "\u6210\u529f",
    "Successfully added %s.": "\u6210\u529f\u6dfb\u52a0 %s\u3002",
    "Successfully added label(s) for library {placeholder}": "\u7ed9\u8d44\u6599\u5e93 {placeholder} \u6dfb\u52a0\u6807\u7b7e\u6210\u529f",
    "Successfully added {email_placeholder}": "\u6210\u529f\u6dfb\u52a0 {email_placeholder}",
    "Successfully change office suite.": "\u5df2\u6210\u529f\u66f4\u6362\u529e\u516c\u5957\u4ef6\u3002",
    "Successfully change the group": "\u66f4\u6539\u7fa4\u7ec4\u6210\u529f",
    "Successfully changed library password.": "\u8d44\u6599\u5e93\u5bc6\u7801\u91cd\u7f6e\u6210\u529f\u3002",
    "Successfully cleaned all errors.": "\u6210\u529f\u6e05\u9664\u6240\u6709\u9519\u8bef\u3002",
    "Successfully cleaned invalid share links.": "\u65e0\u6548\u7684\u5171\u4eab\u94fe\u63a5\u5df2\u6e05\u9664\u3002",
    "Successfully cleaned invalid upload links.": "\u65e0\u6548\u7684\u4e0a\u4f20\u94fe\u63a5\u5df2\u6e05\u9664\u3002",
    "Successfully cleared trash.": "\u6210\u529f\u6e05\u7a7a\u56de\u6536\u7ad9\u3002",
    "Successfully converted the file.": "\u6587\u4ef6\u8f6c\u6362\u6210\u529f",
    "Successfully copied %(name)s and %(amount)s other items.": "\u6210\u529f\u590d\u5236 %(name)s \u548c\u5176\u4ed6 %(amount)s \u9879\u6761\u76ee\u3002",
    "Successfully copied %(name)s and 1 other item.": "\u6210\u529f\u590d\u5236 %(name)s \u548c\u53e61\u9879\u6761\u76ee\u3002",
    "Successfully copied %(name)s.": "\u6210\u529f\u590d\u5236 %(name)s\u3002",
    "Successfully copied files to another library.": "\u6210\u529f\u590d\u5236\u6587\u4ef6\u5230\u53e6\u4e00\u4e2a\u8d44\u6599\u5e93\u3002",
    "Successfully deleted 1 item": "\u6210\u529f\u5220\u9664 1 \u4e2a\u6761\u76ee",
    "Successfully deleted 1 item.": "\u6210\u529f\u5220\u9664 1 \u4e2a\u6761\u76ee\u3002",
    "Successfully deleted 1 share link": "\u6210\u529f\u5220\u9664\u4e86 1 \u4e2a\u5171\u4eab\u94fe\u63a5",
    "Successfully deleted 1 upload link": "\u5df2\u6210\u529f\u5220\u9664 1 \u4e2a\u4e0a\u4f20\u94fe\u63a5",
    "Successfully deleted 1 user.": "\u6210\u529f\u5220\u9664 1 \u4e2a\u7528\u6237\u3002",
    "Successfully deleted {name}": " {name}  \u5220\u9664\u6210\u529f",
    "Successfully deleted {name} and {n} other items": "\u5df2\u6210\u529f\u5220\u9664 {name}  \u548c {n} \u4e2a\u5176\u4ed6\u9879\u76ee",
    "Successfully deleted {name} and {n} other items.": "\u6210\u529f\u5220\u9664\u4e86 {name} \u548c {n} \u4e2a\u5176\u4ed6\u6761\u76ee\u3002",
    "Successfully deleted {name}.": " {name}  \u5220\u9664\u6210\u529f\u3002",
    "Successfully deleted {number_placeholder} share links": "\u6210\u529f\u5220\u9664\u4e86 {number_placeholder} \u4e2a\u5171\u4eab\u94fe\u63a5",
    "Successfully deleted {number_placeholder} upload links": "\u5df2\u6210\u529f\u5220\u9664 {number_placeholder} \u4e2a\u4e0a\u4f20\u94fe\u63a5",
    "Successfully deleted {user_number_placeholder} users.": "\u6210\u529f\u5220\u9664 {user_number_placeholder} \u4e2a\u7528\u6237\u3002",
    "Successfully edited labels.": "\u7f16\u8f91\u6807\u7b7e\u6210\u529f\u3002",
    "Successfully imported {user_placeholder}": "\u5df2\u6210\u529f\u5bfc\u5165 {user_placeholder}",
    "Successfully invited %(email) and %(num) other people.": "\u6210\u529f\u9080\u8bf7\u4e86 %(email) \u548c\u5176\u4ed6 %(num) \u4e2a\u4eba\u3002",
    "Successfully invited %(email).": "\u6210\u529f\u9080\u8bf7\u4e86  %(email)\u3002",
    "Successfully modified permission.": "\u6210\u529f\u66f4\u6539\u6743\u9650\u3002",
    "Successfully moved %(name)s and %(amount)s other items.": "\u6210\u529f\u79fb\u52a8 %(name)s \u548c\u5176\u4ed6 %(amount)s \u9879\u6761\u76ee\u3002",
    "Successfully moved %(name)s and 1 other item.": "\u6210\u529f\u79fb\u52a8 %(name)s \u548c\u53e61\u9879\u6761\u76ee\u3002",
    "Successfully moved %(name)s.": "\u6210\u529f\u79fb\u52a8 %(name)s\u3002",
    "Successfully moved files to another library.": "\u6210\u529f\u79fb\u52a8\u6587\u4ef6\u5230\u53e6\u4e00\u4e2a\u8d44\u6599\u5e93\u3002",
    "Successfully moved {name}.": "\u6210\u529f\u79fb\u52a8 {name}\u3002",
    "Successfully removed {placeholder}.": "\u6210\u529f\u79fb\u9664 {placeholder}\u3002",
    "Successfully restored the library {library_name}.": "\u5df2\u6210\u529f\u8fd8\u539f\u8d44\u6599\u5e93 {library_name} \u3002",
    "Successfully restored the library.": "\u8d44\u6599\u5e93\u8fd8\u539f\u6210\u529f\u3002",
    "Successfully restored.": "\u6062\u590d\u6210\u529f\u3002",
    "Successfully revoke the admin permission of %s": "\u6210\u529f\u53d6\u6d88 %s \u7684\u7ba1\u7406\u6743\u9650",
    "Successfully revoked access of user {placeholder}.": "\u5df2\u6210\u529f\u64a4\u6d88\u7528\u6237 {placeholder} \u7684\u8bbf\u95ee\u6743\u9650\u3002",
    "Successfully revoked the admin permission of {placeholder}.": "\u6210\u529f\u64a4\u9500 {placeholder} \u7684\u7ba1\u7406\u6743\u9650\u3002",
    "Successfully saved": "\u4fdd\u5b58\u6210\u529f",
    "Successfully sent to {placeholder}": "\u6210\u529f\u53d1\u9001\u7ed9 {placeholder}",
    "Successfully set %s as admin.": "\u6210\u529f\u8bbe\u7f6e %s \u4e3a\u7ba1\u7406\u5458\u3002",
    "Successfully set it.": "\u8bbe\u7f6e\u6210\u529f\u3002",
    "Successfully set library history.": "\u6210\u529f\u8bbe\u7f6e\u8d44\u6599\u5e93\u5386\u53f2\u3002",
    "Successfully starred {library_name_placeholder}.": "\u6210\u529f\u6dfb\u52a0\u661f\u6807 {library_name_placeholder}",
    "Successfully transferred the group.": "\u7fa4\u7ec4\u8f6c\u8ba9\u6210\u529f\u3002",
    "Successfully transferred the library.": "\u8d44\u6599\u5e93\u8f6c\u8ba9\u6210\u529f\u3002",
    "Successfully unlinked %(name)s.": "\u6210\u529f\u65ad\u5f00\u8fde\u63a5 %(name)s \u3002",
    "Successfully unlinked the device.": "\u6210\u529f\u65ad\u5f00\u8fde\u63a5\u8be5\u8bbe\u5907 \u3002",
    "Successfully unshared library {placeholder}": "\u6210\u529f\u53d6\u6d88\u5171\u4eab\u8d44\u6599\u5e93 {placeholder}",
    "Successfully unshared {name}": "\u6210\u529f\u53d6\u6d88\u5171\u4eab {name}",
    "Successfully unstarred {library_name_placeholder}.": "\u6210\u529f\u53d6\u6d88\u661f\u6807 {library_name_placeholder}",
    "Suggestion": "\u5efa\u8bae",
    "Switch sort mode": "\u5207\u6362\u6392\u5e8f\u6a21\u5f0f",
    "Switch to plain text editor": "\u5207\u6362\u81f3\u666e\u901a\u6587\u672c\u7f16\u8f91\u5668",
    "Switch to rich text editor": "\u5207\u6362\u81f3\u5bcc\u6587\u672c\u7f16\u8f91\u5668",
    "Switch view mode": "\u5207\u6362\u89c6\u56fe\u6a21\u5f0f",
    "Sync": "\u540c\u6b65",
    "Sync Download": "\u540c\u6b65\u4e0b\u8f7d",
    "Sync Traffic": "\u540c\u6b65\u7aef\u6d41\u91cf",
    "Sync Upload": "\u540c\u6b65\u4e0a\u4f20",
    "System": "\u7cfb\u7edf",
    "System Admin": "\u7cfb\u7edf\u7ba1\u7406",
    "System Info": "\u7cfb\u7edf\u4fe1\u606f",
    "System settings updated": "\u7cfb\u7edf\u8bbe\u7f6e\u5df2\u66f4\u65b0",
    "Table": "\u8868\u683c",
    "Tag": "\u6807\u7b7e",
    "Tag \"{name}\" already exists.": "\u6807\u7b7e \"{name}\" \u5df2\u7ecf\u5b58\u5728\u3002",
    "Tag not found": "\u6807\u7b7e\u672a\u627e\u5230",
    "Tagged Files": "\u6253\u6807\u7b7e\u7684\u6587\u4ef6",
    "Tags": "\u6807\u7b7e",
    "Tags imported": "\u5bfc\u5165\u7684\u6807\u7b7e",
    "Tags language:": "\u6807\u7b7e\u8bed\u8a00",
    "Team name": "\u56e2\u961f\u540d\u79f0",
    "Template": "\u6a21\u677f",
    "Terms": "\u4f7f\u7528\u6761\u6b3e",
    "Terms and Conditions": "\u8f6f\u4ef6\u4f7f\u7528\u6761\u6b3e",
    "Text": "\u6587\u672c",
    "Text extracted": "\u6587\u672c\u5df2\u63d0\u53d6",
    "Text file extensions": "\u6587\u672c\u6587\u4ef6\u6269\u5c55\u540d",
    "Text is required.": "\u5185\u5bb9\u4e3a\u5fc5\u586b\u9879\u3002",
    "Text wraps": "\u6587\u672c\u6362\u884c",
    "The content of the document has exceeded the limit of 100000 characters, and only the first 100000 characters are saved": "\u6587\u6863\u5185\u5bb9\u5df2\u8d85\u8fc7100000\u4e2a\u5b57\u7b26\u7684\u9650\u5236\uff0c\u4ec5\u4fdd\u5b58\u524d100000\u4e2a\u5b57\u7b26",
    "The content of the document has exceeded the limit of 100000 characters, and the content cannot be saved": "\u6587\u6863\u5185\u5bb9\u5df2\u8d85\u8fc7100000\u4e2a\u5b57\u7b26\u7684\u9650\u5236\uff0c\u65e0\u6cd5\u4fdd\u5b58",
    "The current quota for {group_name} is {quota}": "\u7fa4\u7ec4 {group_name} \u7684\u5f53\u524d\u914d\u989d\u662f {quota}",
    "The custom part of the URL must be between 5 and 30 characters long and may only contain letters (a-z), numbers, and hyphens.": "URL \u7684\u81ea\u5b9a\u4e49\u90e8\u5206\u957f\u5ea6\u5fc5\u987b\u57285\u523030\u4e2a\u5b57\u7b26\u4e4b\u95f4\uff0c\u5e76\u4e14\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\uff08a-z\uff09\uff0c\u6570\u5b57\u548c\u8fde\u5b57\u7b26\u3002",
    "The file is too large. Allowed maximum size is 1MB.": " \u6587\u4ef6\u592a\u5927\u3002\u4e0d\u5f97\u8d85\u8fc7 1MB\u3002",
    "The image could not be previewed.": "\u65e0\u6cd5\u9884\u89c8\u56fe\u50cf\u3002",
    "The imported options already exists": "\u5bfc\u5165\u7684\u6807\u7b7e\u5df2\u7ecf\u5b58\u5728",
    "The imported options are invalid": "\u5bfc\u5165\u7684\u9009\u9879\u65e0\u6548",
    "The imported tag already exists": "\u5bfc\u5165\u7684\u6807\u7b7e\u5df2\u5b58\u5728",
    "The imported tags are invalid": "\u5bfc\u5165\u7684\u6807\u7b7e\u65e0\u6548",
    "The least number of characters a share/upload link password should include.": "\u5171\u4eab\u5916\u94fe/\u4e0a\u4f20\u5916\u94fe\u5bc6\u7801\u9700\u8981\u5305\u542b\u7684\u6700\u5c11\u5b57\u7b26\u4e2a\u6570\u3002",
    "The least number of characters an encrypted library password should include.": "\u52a0\u5bc6\u8d44\u6599\u5e93\u7684\u6700\u5c0f\u5bc6\u7801\u957f\u5ea6\u3002",
    "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols": "\u5171\u4eab\u5916\u94fe/\u4e0a\u4f20\u5916\u94fe\u7684\u5bc6\u7801\u5f3a\u5ea6 (1-4)\u3002\u4f8b\u5982\uff0c3 \u8868\u793a\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u4ee5\u4e0b\u4e2d\u7684\u4e09\u79cd\uff1a\u6570\u5b57\uff0c\u5927\u5199\u5b57\u6bcd\uff0c\u5c0f\u5199\u5b57\u6bcd\u548c\u5176\u4ed6\u7b26\u53f7",
    "The link is copied to the clipboard.": "\u5916\u94fe\u5df2\u590d\u5236\u5230\u526a\u8d34\u677f\u3002",
    "The list of added, deleted and modified files will be sent to your mailbox.": "\u6dfb\u52a0\uff0c\u5220\u9664\u548c\u4fee\u6539\u7684\u6587\u4ef6\u5217\u8868\u5c06\u53d1\u9001\u5230\u4f60\u7684\u90ae\u7bb1\u3002",
    "The maximum number of failed login attempts before showing CAPTCHA.": "\u7528\u6237\u767b\u5f55\u5931\u8d25\u51e0\u6b21\u540e\u663e\u793a\u9a8c\u8bc1\u7801\u3002",
    "The name \"{name}\" is already taken. Please choose a different name.": "\u540d\u79f0\u201c{name}\u201d\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u9009\u53d6\u4e00\u4e2a\u4e0d\u540c\u7684\u540d\u79f0\u3002",
    "The next month": "\u4e0b\u4e2a\u6708",
    "The next numbers of days": "\u4eca\u5929\u4e4b\u540e\u7684\u6307\u5b9a\u5929\u6570",
    "The next week": "\u4e0b\u4e2a\u661f\u671f",
    "The next year": "\u4e0b\u4e00\u5e74",
    "The owner of this library has run out of space.": "\u8be5\u8d44\u6599\u5e93\u62e5\u6709\u8005\u7684\u7a7a\u95f4\u5df2\u7528\u5b8c\u3002",
    "The password is too short.": "\u5bc6\u7801\u592a\u77ed\u3002",
    "The password is too weak. It should include at least {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols.": "\u5bc6\u7801\u5f3a\u5ea6\u4e0d\u591f\u3002\u81f3\u5c11\u9700\u8981\u5305\u62ec\u4ee5\u4e0b\u4e2d\u7684 {passwordStrengthLevel} \u79cd\uff1a\u6570\u5b57\uff0c\u5927\u5199\u5b57\u6bcd\uff0c\u5c0f\u5199\u5b57\u6bcd\u548c\u5176\u4ed6\u7b26\u53f7\u3002",
    "The password will be kept in the server for only 1 hour.": "\u5bc6\u7801\u5c06\u5728\u670d\u52a1\u5668\u4e0a\u4fdd\u5b58 1 \u5c0f\u65f6\u3002",
    "The past month": "\u4e0a\u4e2a\u6708",
    "The past numbers of days": "\u4eca\u5929\u4e4b\u524d\u7684\u6307\u5b9a\u5929\u6570",
    "The past week": "\u4e0a\u4e2a\u661f\u671f",
    "The past year": "\u53bb\u5e74",
    "The row is locked and cannot be modified": "\u8be5\u884c\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u4fee\u6539",
    "There is another option with this name": "\u8fd8\u6709\u4e00\u4e2a\u76f8\u540c\u540d\u79f0\u7684\u9009\u9879",
    "There is another property with this name": "\u8fd8\u6709\u53e6\u4e00\u4e2a\u5177\u6709\u6b64\u540d\u79f0\u7684\u5c5e\u6027",
    "There is no information to display.": "\u6ca1\u6709\u53ef\u663e\u793a\u7684\u4fe1\u606f\u3002",
    "This file has (apparently) not been accessed yet": "\u8fd9\u4e2a\u6587\u4ef6\u76ee\u524d\u5e76\u6ca1\u6709\u88ab\u8bbf\u95ee",
    "This file has been updated.": "\u8fd9\u4e2a\u6587\u4ef6\u5df2\u88ab\u4fee\u6539\u3002",
    "This folder has been shared to {user_amount} user(s) and {group_amount} group(s).": "\u8be5\u76ee\u5f55\u5df2\u88ab\u5171\u4eab\u7ed9 {user_amount} \u4e2a\u7528\u6237\u548c {group_amount} \u4e2a\u7fa4\u7ec4\u3002",
    "This folder has no content at this time.": "\u8be5\u76ee\u5f55\u6682\u65e0\u4efb\u4f55\u5185\u5bb9\u3002",
    "This is a special group representing a department.": "\u8be5\u7fa4\u7ec4\u4ee3\u8868\u4e00\u4e2a\u90e8\u95e8\u3002",
    "This is required": "\u8fd9\u662f\u5fc5\u586b\u9879",
    "This library has been set to read-only by admin and cannot be updated.": "\u6b64\u5e93\u5df2\u7531\u7ba1\u7406\u5458\u8bbe\u7f6e\u4e3a\u53ea\u8bfb\uff0c\u65e0\u6cd5\u66f4\u65b0\u3002",
    "This library has been shared to {user_amount} user(s) and {group_amount} group(s).": "\u8be5\u8d44\u6599\u5e93\u5df2\u88ab\u5171\u4eab\u7ed9 {user_amount} \u4e2a\u7528\u6237\u548c {group_amount} \u4e2a\u7fa4\u7ec4\u3002",
    "This library is password protected": "\u8be5\u8d44\u6599\u5e93\u5df2\u52a0\u5bc6",
    "This month": "\u8fd9\u4e2a\u6708",
    "This operation will not be reverted. Please think twice!": "\u8be5\u64cd\u4f5c\u5c06\u4e0d\u53ef\u64a4\u9500\u3002\u8bf7\u4e09\u601d\uff01",
    "This property can not be deleted": "\u8fd9\u4e2a\u5c5e\u6027\u4e0d\u80fd\u88ab\u5220\u9664",
    "This property does not support sorting": "\u8fd9\u4e2a\u5c5e\u6027\u4e0d\u652f\u6301\u6392\u5e8f",
    "This property is not editable": "\u8fd9\u4e2a\u5c5e\u6027\u4e0d\u652f\u6301\u7f16\u8f91",
    "This user has not created or joined any groups": "\u6b64\u7528\u6237\u6ca1\u6709\u521b\u5efa\u6216\u52a0\u5165\u7fa4\u7ec4",
    "This week": "\u8fd9\u4e2a\u661f\u671f",
    "This year": "\u4eca\u5e74",
    "Thumbnail": "\u7f29\u7565\u56fe",
    "Time": "\u65f6\u95f4",
    "Tip: -2 means no limit.": "\u63d0\u793a\uff1a-2 \u8868\u793a\u6ca1\u6709\u9650\u5236\u3002",
    "Tip: 0 means default limit": "Tip: \u8bbe\u7f6e\u4e3a0\u8868\u793a\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u4e0a\u9650",
    "Tip: 0 means default limit, the unit is MB": "\u63d0\u793a\uff1a0 \u8868\u793a\u9ed8\u8ba4\u9650\u5236\uff0c\u5355\u4f4d\u4e3a MB",
    "Tip: a snapshot will be generated after modification, which records the library state after the modification.": "Tip\uff1a\u5728\u6bcf\u6b21\u4fee\u6539\u540e\u4f1a\u751f\u6210\u4e00\u4e2a\u955c\u50cf\uff0c\u8bb0\u5f55\u4fee\u6539\u4e4b\u524d\u7684\u76ee\u5f55\u72b6\u6001\u3002",
    "Tip: libraries deleted {placeholder} days ago will be cleaned automatically.": "\u63d0\u793a\uff1a{placeholder} \u5929\u524d\u5220\u9664\u7684\u8d44\u6599\u5e93\u4f1a\u88ab\u81ea\u52a8\u6e05\u9664\u3002",
    "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.": "\u63d0\u793a\uff1a{trashReposExpireDays} \u5929\u524d\u5220\u9664\u7684\u8d44\u6599\u5e93\u4f1a\u88ab\u81ea\u52a8\u6e05\u7a7a\u3002",
    "Tip: you can search by keyword in name or ID.": "\u63d0\u793a\uff1a\u53ef\u4ee5\u7528\u540d\u79f0\u6216 ID \u4e2d\u7684\u5173\u952e\u8bcd\u6765\u641c\u7d22\u3002",
    "Tip: you can search by keyword in name.": "\u63d0\u793a\uff1a\u53ef\u4ee5\u7528\u540d\u79f0\u5173\u952e\u8bcd\u6765\u641c\u7d22\u3002",
    "Title property": "\u6807\u9898\u5c5e\u6027",
    "Today": "\u4eca\u5929",
    "Token": "\u9a8c\u8bc1\u7801",
    "Token:": "Token:",
    "Tomorrow": "\u660e\u5929",
    "Too many requests": "\u8bf7\u6c42\u592a\u591a",
    "Total Devices": "\u6240\u6709\u7684\u8bbe\u5907",
    "Total Storage": "\u603b\u5b58\u50a8\u7a7a\u95f4",
    "Total Traffic": "\u603b\u6d41\u91cf",
    "Total Users": "\u603b\u7528\u6237\u6570",
    "Total users": "\u603b\u7528\u6237",
    "Traffic": "\u6d41\u91cf",
    "Traffic this month": "\u672c\u6708\u6d41\u91cf",
    "Transfer": "\u8f6c\u8ba9",
    "Transfer Group": "\u8f6c\u8ba9\u7fa4\u7ec4",
    "Transfer Group {placeholder} to": "\u5c06\u7fa4\u7ec4 {placeholder} \u8f6c\u8ba9\u7ed9",
    "Transfer Library": "\u8f6c\u8ba9\u8d44\u6599\u5e93",
    "Transfer Library {library_name}": "\u8f6c\u8ba9\u8d44\u6599\u5e93 {library_name}",
    "Transfer group to": "\u8f6c\u6362\u7fa4\u7ec4\u7ed9",
    "Transfer to department": "\u8f6c\u8ba9\u7ed9\u90e8\u95e8",
    "Transfer to user": "\u8f6c\u8ba9\u7ed9\u7528\u6237",
    "Transferred group {group_name} from {user_from} to {user_to}": "\u5df2\u628a\u7fa4\u7ec4 {group_name} \u4ece {user_from} \u8f6c\u8ba9\u7ed9 {user_to}",
    "Transferred library {library_name} from {user_from} to {user_to}": "\u5df2\u628a\u8d44\u6599\u5e93 {library_name} \u4ece {user_from} \u8f6c\u8ba9\u7ed9 {user_to}",
    "Trash": "\u56de\u6536\u7ad9",
    "Turn off": "\u5173\u95ed",
    "Turn off OCR": "\u5173\u95ed OCR",
    "Turn off extended properties": "\u5173\u95ed\u6269\u5c55\u5c5e\u6027",
    "Turn off face recognition": "\u5173\u95ed\u4eba\u8138\u8bc6\u522b",
    "Turn off tags": "\u5173\u95ed\u6807\u7b7e",
    "Turn on extensible properties and views to experience a new way of managing files": "\u6253\u5f00\u53ef\u6269\u5c55\u5c5e\u6027\u548c\u89c6\u56fe\uff0c\u4f53\u9a8c\u7ba1\u7406\u6587\u4ef6\u7684\u65b0\u65b9\u6cd5",
    "Two-Factor Authentication": "\u4e24\u6b65\u9a8c\u8bc1",
    "Two-factor authentication is not enabled for your account. Enable two-factor authentication for enhanced account security.": "\u4f60\u7684\u8d26\u53f7\u5e76\u672a\u5f00\u542f\u4e24\u6b65\u9a8c\u8bc1\uff0c\u8bf7\u5f00\u542f\u4e24\u6b65\u9a8c\u8bc1\u589e\u52a0\u8d26\u53f7\u5b89\u5168\u6027\u3002",
    "Type": "\u7c7b\u578b",
    "Type characters to start search": "\u8f93\u5165\u5b57\u7b26\u5f00\u59cb\u641c\u7d22",
    "URL is copied to the clipboard": "URL \u5df2\u7ecf\u590d\u5236\u5230\u526a\u8d34\u677f",
    "URL is required": "URL \u662f\u5fc5\u586b\u9879",
    "US": "\u7f8e\u56fd",
    "Uncategorized": "\u672a\u5206\u7c7b",
    "Undo": "\u64a4\u9500",
    "Unfold": "\u5c55\u5f00",
    "Unfold the sidebar": "\u5c55\u5f00\u4fa7\u8fb9\u680f",
    "Unfreeze Document": "\u89e3\u9664\u51bb\u7ed3",
    "Unhandled": "\u672a\u5904\u7406",
    "Unknown": "\u672a\u77e5",
    "Unknown people": "\u672a\u77e5\u4eba\u7269",
    "Unlink": "\u65ad\u5f00\u8fde\u63a5",
    "Unlink device": "\u65ad\u5f00\u8fde\u63a5\u8bbe\u5907",
    "Unlock": "\u89e3\u9501",
    "Unpublish": "\u53d6\u6d88\u53d1\u5e03",
    "Unpublish Wiki": "\u53d6\u6d88\u53d1\u5e03\u77e5\u8bc6\u5e93",
    "Unselect": "\u4e0d\u9009\u62e9",
    "Unselect all": "\u53d6\u6d88\u9009\u62e9\u5168\u90e8",
    "Unselect all items": "\u53d6\u6d88\u9009\u62e9\u6240\u6709\u6761\u76ee",
    "Unselect this item": "\u53d6\u6d88\u9009\u62e9\u8be5\u6761\u76ee",
    "Unshare": "\u53d6\u6d88\u5171\u4eab",
    "Unshare Library": "\u53d6\u6d88\u5171\u4eab\u8d44\u6599\u5e93",
    "Unstar": "\u53d6\u6d88\u661f\u6807",
    "Untitled": "\u672a\u547d\u540d",
    "Unwatch File Changes": "\u53d6\u6d88\u6587\u4ef6\u6539\u52a8\u5173\u6ce8",
    "Up": "\u5347\u5e8f",
    "Update": "\u66f4\u65b0",
    "Update Terms and Conditions": "\u66f4\u65b0\u8f6f\u4ef6\u4f7f\u7528\u6761\u6b3e",
    "Update password": "\u66f4\u65b0\u5bc6\u7801",
    "Update succeeded.": "\u66f4\u65b0\u6210\u529f\u3002",
    "Updated draft": "\u66f4\u65b0\u8349\u7a3f",
    "Updated file": "\u66f4\u65b0\u6587\u4ef6",
    "Upgrade to Pro Edition": "\u5347\u7ea7\u5230\u4e13\u4e1a\u7248",
    "Upload": "\u4e0a\u4f20",
    "Upload Files": "\u4e0a\u4f20\u6587\u4ef6",
    "Upload Folder": "\u4e0a\u4f20\u76ee\u5f55",
    "Upload Link": "\u4e0a\u4f20\u94fe\u63a5",
    "Upload Links": "\u4e0a\u4f20\u94fe\u63a5",
    "Upload file": "\u4e0a\u4f20\u6587\u4ef6",
    "Upload files to {folder_name_placeholder}": "\u4e0a\u4f20\u6587\u4ef6\u5230  {folder_name_placeholder}",
    "Upload license": "\u4e0a\u4f20\u8bb8\u53ef\u8bc1",
    "Upload link is copied to the clipboard.": "\u4e0a\u4f20\u8fde\u63a5\u5df2\u590d\u5236\u5230\u526a\u5207\u677f\u3002",
    "Uploaded": "\u5df2\u4e0a\u4f20",
    "Uploading...": "\u4e0a\u4f20\u4e2d...",
    "Use custom CSS": "\u4f7f\u7528\u5b9a\u5236\u7684 CSS",
    "Use information from your Identity Provider to configure Seafile": "\u4f7f\u7528\u6765\u81ea\u4f60\u7684 Identity Provider \u7684\u4fe1\u606f\u914d\u7f6e Seafile",
    "Use the import/export function to transfer options quickly. (The export is in JSON format.) By pasting cells, copied from a text column, an Excel or a TXT file, you can also add options quickly.": "\u4f7f\u7528\u5bfc\u5165/\u5bfc\u51fa\u529f\u80fd\u5feb\u901f\u4f20\u8f93\u9009\u9879\u3002\uff08\u5bfc\u51fa\u4e3aJSON\u683c\u5f0f\uff09\u3002\u901a\u8fc7\u7c98\u8d34\u4ece\u6587\u672c\u3001Excel \u6216 TXT \u6587\u4ef6\u590d\u5236\u7684\u5355\u5143\u683c\uff0c\u4f60\u8fd8\u53ef\u4ee5\u5feb\u901f\u6dfb\u52a0\u9009\u9879\u3002",
    "Use the import/export function to transfer tags quickly to another library. (The export is in JSON format.)": "\u4f7f\u7528\u5bfc\u5165/\u5bfc\u51fa\u529f\u80fd\u6765\u5feb\u901f\u4f20\u8f93\u6807\u7b7e\u5230\u53e6\u4e00\u4e2a\u8d44\u6599\u5e93\u3002\uff08\u5bfc\u51fa\u6587\u4ef6\u4e3a JSON \u683c\u5f0f\u3002\uff09",
    "Use these values to configure your Identity Provider": "\u4f7f\u7528\u8fd9\u4e9b\u503c\u914d\u7f6e\u4f60\u7684 Identity Provider",
    "Used:": "\u5df2\u7528\u7a7a\u95f4\uff1a",
    "User": "\u7528\u6237",
    "User Email": "\u7528\u6237\u90ae\u7bb1",
    "User Permission": "\u7528\u6237\u6743\u9650",
    "User Shares": "\u7528\u6237\u5171\u4eab",
    "User Storage": "\u7528\u6237\u5b58\u50a8\u7a7a\u95f4",
    "User can not see this folder.": "\u8be5\u76ee\u5f55\u4e0d\u53ef\u89c1\u3002",
    "User can only view files online via browser. Files can't be downloaded.": "\u7528\u6237\u53ea\u80fd\u901a\u8fc7\u6d4f\u89c8\u5668\u5728\u7ebf\u67e5\u770b\u6587\u4ef6\u3002\u6587\u4ef6\u4e0d\u80fd\u88ab\u4e0b\u8f7d\u3002",
    "User can read, download and sync files.": "\u7528\u6237\u53ef\u4ee5\u67e5\u770b\u3001\u4e0b\u8f7d\u548c\u540c\u6b65\u6587\u4ef6\u3002",
    "User can read, write, upload, download and sync files.": "\u7528\u6237\u53ef\u4ee5\u67e5\u770b\u3001\u4fee\u6539\u3001\u4e0a\u4f20\u3001\u4e0b\u8f7d\u548c\u540c\u6b65\u6587\u4ef6\u3002",
    "User can view and edit file online via browser. Files can't be downloaded.": "\u7528\u6237\u53ef\u4ee5\u901a\u8fc7\u6d4f\u89c8\u5668\u5728\u7ebf\u67e5\u770b\u548c\u7f16\u8f91\u6587\u4ef6\u3002 \u6587\u4ef6\u4e0d\u80fd\u88ab\u4e0b\u8f7d\u3002",
    "User default quota": "\u7528\u6237\u9ed8\u8ba4\u914d\u989d",
    "User default quota updated": "\u7528\u6237\u9ed8\u8ba4\u914d\u989d\u5df2\u66f4\u65b0",
    "User deleted": "\u7528\u6237\u5df2\u5220\u9664",
    "User info updated": "\u7528\u6237\u4fe1\u606f\u5df2\u66f4\u65b0",
    "User is already in this group": "\u7528\u6237\u5df2\u5728\u8fd9\u4e2a\u7fa4\u7ec4\u4e2d",
    "User migrate from {user_from} to {user_to}": "\u7528\u6237\u4ece {user_from} \u8fc1\u79fb\u5230 {user_to}",
    "User not found": "\u672a\u627e\u5230\u7528\u6237",
    "User number limit": "\u7528\u6237\u6570\u9650\u5236",
    "User {user_link} has added you to {group_link}": "\u7528\u6237 {user_link} \u5c06\u4f60\u52a0\u5165\u5230\u7fa4\u7ec4 {group_link}\u3002",
    "Username:": "\u7528\u6237\u540d\uff1a",
    "Users": "\u7528\u6237",
    "Verified": "\u5df2\u9a8c\u8bc1",
    "Verify": "\u9a8c\u8bc1",
    "Verify Domain": "\u9a8c\u8bc1\u57df\u540d",
    "Version": "\u7248\u672c",
    "Version Number": "\u7248\u672c\u53f7",
    "Version Number is required.": "\u7248\u672c\u53f7\u4e3a\u5fc5\u586b\u9879\u3002",
    "Version Number must be a number.": "\u7248\u672c\u53f7\u5fc5\u987b\u662f\u6570\u5b57\u3002",
    "Video": "\u89c6\u9891",
    "View": "\u67e5\u770b",
    "View Link": "\u67e5\u770b\u94fe\u63a5",
    "View Related Snapshot": "\u67e5\u770b\u76f8\u5173\u955c\u50cf",
    "View Snapshot": "\u67e5\u770b\u955c\u50cf",
    "View all notifications": "\u67e5\u770b\u6240\u6709\u901a\u77e5",
    "View original image": "\u67e5\u770b\u539f\u56fe",
    "View profile and more": "\u67e5\u770b\u4e2a\u4eba\u8d44\u6599",
    "View published page": "\u67e5\u770b\u5df2\u53d1\u5e03\u9875\u9762",
    "Views": "\u89c6\u56fe",
    "Virus": "\u75c5\u6bd2",
    "Virus File": "\u75c5\u6bd2\u6587\u4ef6",
    "Virus Scan": "\u75c5\u6bd2\u626b\u63cf",
    "Visit count": "\u8bbf\u95ee\u6b21\u6570",
    "Visit old version page": "\u8bbf\u95ee\u65e7\u7248\u9875\u9762",
    "Visited": "\u8bbf\u95ee\u7684",
    "Visits": "\u8bbf\u95ee\u6b21\u6570",
    "Waiting...": "\u7b49\u5019\u4e2d...",
    "Watch File Changes": "\u5173\u6ce8\u6587\u4ef6\u6539\u52a8",
    "Web API Auth Token": "Web API Auth Token",
    "Web Download": "\u7f51\u9875\u4e0b\u8f7d",
    "Web Traffic": "\u7f51\u9875\u7aef\u6d41\u91cf",
    "Web Upload": "\u7f51\u9875\u4e0a\u4f20",
    "WebDAV Access": "WebDAV \u8bbf\u95ee",
    "WebDAV password:": "WebDAV \u5bc6\u7801\uff1a",
    "WebDAV username:": "WebDAV \u7528\u6237\uff1a",
    "Welcome to {site_name_placeholder}": "\u6b22\u8fce\u4f7f\u7528 {site_name_placeholder}",
    "Whether the notifications of collaboration such as sharing library or joining group should be sent to your mailbox.": "\u662f\u5426\u5c06\u5171\u4eab\u8d44\u6599\u5e93\u6216\u662f\u52a0\u5165\u7fa4\u7ec4\u4e4b\u7c7b\u7684\u534f\u4f5c\u901a\u77e5\u53d1\u9001\u5230\u4f60\u7684\u90ae\u7bb1\u3002",
    "Wiki custom URL deleted": "\u77e5\u8bc6\u5e93\u81ea\u5b9a\u4e49 URL \u5df2\u5220\u9664",
    "Wiki owner": "\u77e5\u8bc6\u5e93\u6240\u6709\u8005",
    "Wiki published": "\u77e5\u8bc6\u5e93\u5df2\u53d1\u5e03",
    "Wikis": "\u77e5\u8bc6\u5e93",
    "Workspace": "\u5de5\u4f5c\u533a",
    "Wrong password": "\u5bc6\u7801\u9519\u8bef",
    "Year": "\u5e74",
    "Yesterday": "\u6628\u5929",
    "You are watching file changes of this library.": "\u4f60\u6b63\u5728\u5173\u6ce8\u8be5\u8d44\u6599\u5e93\u4e2d\u7684\u6587\u4ef6\u6539\u52a8\u3002",
    "You can add a Wiki by clicking the \"Add Wiki\" item in the dropdown menu.": "\u4f60\u53ef\u4ee5\u70b9\u51fb\u4e0b\u62c9\u83dc\u5355\u4e2d\u7684 \u201c\u589e\u52a0\u77e5\u8bc6\u5e93\u201d \u6761\u76ee\u6765\u6dfb\u52a0\u77e5\u8bc6\u5e93\u3002",
    "You can also add a user as a guest, who will not be allowed to create libraries and groups.": "\u53ef\u4ee5\u6dfb\u52a0\u4e00\u4e2a\u201c\u8bbf\u5ba2\u201d\u7528\u6237\uff0c\u201c\u8bbf\u5ba2\u201d\u7528\u6237\u65e0\u6cd5\u521b\u5efa\u8d44\u6599\u5e93\u548c\u7fa4\u7ec4\u3002",
    "You can create files quickly": "\u4f60\u53ef\u4ee5\u5feb\u901f\u521b\u5efa\u6587\u4ef6",
    "You can create libraries by clicking the \"New Library\" item in the dropdown menu.": "\u4f60\u53ef\u4ee5\u901a\u8fc7\u5355\u51fb\u4e0b\u62c9\u83dc\u5355\u4e2d\u7684\u201c\u65b0\u5efa\u8d44\u6599\u5e93\u201d\u9879\u6765\u521b\u5efa\u8d44\u6599\u5e93\u3002",
    "You can enter multiple emails. An invitation link will be sent to each of them.": "\u4f60\u53ef\u4ee5\u8f93\u5165\u591a\u4e2a\u90ae\u7bb1\u3002\u6bcf\u4e2a\u90ae\u7bb1\u90fd\u5c06\u6536\u5230\u4e00\u4e2a\u9080\u8bf7\u94fe\u63a5\u3002",
    "You can use this field at login.": "\u4f60\u53ef\u4ee5\u7528\u8be5\u5b57\u6bb5\u767b\u5f55\u3002",
    "You do not have any Wikis yet.": "\u4f60\u8fd8\u6ca1\u6709\u77e5\u8bc6\u5e93\u3002",
    "You do not have permission": "\u4f60\u6ca1\u6709\u6743\u9650",
    "You don't have any favorite items yet": "\u4f60\u8fd8\u6ca1\u6709\u4efb\u4f55\u661f\u6807\u9879\u76ee",
    "You don't have any share links": "\u4f60\u6ca1\u6709\u4efb\u4f55\u5206\u4eab\u94fe\u63a5\u3002",
    "You don't have any upload links": "\u4f60\u8fd8\u6ca1\u6709\u4efb\u4f55\u4e0a\u4f20\u5916\u94fe",
    "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "\u4f60\u8fd8\u6ca1\u6709\u901a\u8fc7\u4efb\u4f55\uff08\u684c\u9762\u6216\u79fb\u52a8\uff09\u5ba2\u6237\u7aef\u8bbf\u95ee\u6587\u4ef6\u3002\u53ef\u4ee5\u914d\u7f6e\u4e0b\u5ba2\u6237\u7aef\uff0c\u8fd9\u6837\u53ef\u4ee5\u66f4\u65b9\u4fbf\u5730\u8bbf\u95ee\u6570\u636e\u3002",
    "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.": "\u4f60\u8fd8\u6ca1\u6dfb\u52a0\u4efb\u4f55\u8d44\u6599\u5e93\uff0c\u76ee\u5f55\u6216\u6587\u4ef6\u5230\u4f60\u7684\u6536\u85cf\u5939\u3002\u6536\u85cf\u5939\u53ef\u4ee5\u8ba9\u4f60\u5feb\u901f\u8bbf\u95ee\u6700\u5e38\u7528\u7684\u6761\u76ee\u3002\u4f60\u53ef\u4ee5\u901a\u8fc7\u70b9\u51fb\u5176\u540d\u79f0\u5de6\u4fa7\u7684\u661f\u6807\uff0c\u5c06\u4e00\u4e2a\u8d44\u6599\u5e93\uff0c\u76ee\u5f55\u6216\u6587\u4ef6\u6dfb\u52a0\u5230\u6536\u85cf\u5939\u3002",
    "You have not created any libraries yet. A library is a container to organize your files and folders. A library can also be shared with others and synced to your connected devices. You can create a library by clicking the \"New Library\" item in the dropdown menu.": "\u4f60\u5c1a\u672a\u521b\u5efa\u4efb\u4f55\u8d44\u6599\u5e93\u3002\u8d44\u6599\u5e93\u662f\u4e00\u4e2a\u7528\u4e8e\u7ec4\u7ec7\u6587\u4ef6\u548c\u6587\u4ef6\u5939\u7684\u5bb9\u5668\u3002\u8d44\u6599\u5e93\u4e5f\u53ef\u4ee5\u4e0e\u4ed6\u4eba\u5171\u4eab\u5e76\u540c\u6b65\u5230\u4f60\u8fde\u63a5\u7684\u8bbe\u5907\u3002\u4f60\u53ef\u4ee5\u901a\u8fc7\u5355\u51fb\u4e0b\u62c9\u83dc\u5355\u4e2d\u7684\u201c\u65b0\u5efa\u8d44\u6599\u5e93\u201d\u9009\u9879\u6765\u521b\u5efa\u8d44\u6599\u5e93\u3002",
    "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.": "\u4f60\u8fd8\u6ca1\u521b\u5efa\u4efb\u4f55\u5171\u4eab\u5916\u94fe\u3002\u4e00\u4e2a\u5171\u4eab\u5916\u94fe\u53ef\u4ee5\u7528\u6765\u5171\u4eab\u6587\u4ef6\u548c\u76ee\u5f55\u7ed9\u4efb\u4f55\u4eba\u3002\u53ef\u4ee5\u901a\u8fc7\u70b9\u51fb\u5176\u540d\u79f0\u65c1\u8fb9\u7684\u5171\u4eab\u56fe\u6807\u6765\u7ed9\u4e00\u4e2a\u6587\u4ef6\u6216\u76ee\u5f55\u521b\u5efa\u4e00\u4e2a\u5171\u4eab\u5916\u94fe\u3002",
    "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.": "\u4f60\u8fd8\u6ca1\u521b\u5efa\u4efb\u4f55\u4e0a\u4f20\u5916\u94fe\u3002\u4e00\u4e2a\u4e0a\u4f20\u5916\u94fe\u5141\u8bb8\u4efb\u4f55\u4eba\u4e0a\u4f20\u6587\u4ef6\u5230\u4e00\u4e2a\u76ee\u5f55\u6216\u8d44\u6599\u5e93\u3002\u53ef\u4ee5\u901a\u8fc7\u70b9\u51fb\u5176\u540d\u79f0\u65c1\u8fb9\u7684\u5171\u4eab\u56fe\u6807\u6765\u7ed9\u4e00\u4e2a\u76ee\u5f55\u6216\u8d44\u6599\u5e93\u521b\u5efa\u4e00\u4e2a\u4e0a\u4f20\u5916\u94fe\u3002",
    "You have not deleted any libraries in the last {placeholder} days. A deleted library will be cleaned automatically after this period.": "\u5728\u8fc7\u53bb {placeholder} \u5929\u4f60\u6ca1\u6709\u5220\u9664\u4efb\u4f55\u8d44\u6599\u5e93\u3002\u4e00\u4e2a\u88ab\u5220\u9664\u7684\u8d44\u6599\u5e93\u5c06\u5728\u8fd9\u4e2a\u65f6\u95f4\u6bb5\u540e\u88ab\u81ea\u52a8\u6e05\u9664\u3002",
    "You have not invited any guests yet. A guest can access shared libraries through the web interface allowing more efficient ways to collaborate than through links. You can invite a guest by clicking the \"Invite Guest\" item in the dropdown menu.": "\u4f60\u5c1a\u672a\u9080\u8bf7\u4efb\u4f55\u8bbf\u5ba2\u3002\u8bbf\u5ba2\u53ef\u4ee5\u901a\u8fc7 web \u754c\u9762\u8bbf\u95ee\u5171\u4eab\u8d44\u6599\u5e93\uff0c\u4ece\u800c\u6bd4\u901a\u8fc7\u94fe\u63a5\u66f4\u6709\u6548\u5730\u8fdb\u884c\u534f\u4f5c\u3002\u4f60\u53ef\u4ee5\u901a\u8fc7\u5355\u51fb\u4e0b\u62c9\u83dc\u5355\u4e2d\u7684\u201c\u9080\u8bf7\u8bbf\u5ba2\u201d\u9009\u9879\u6765\u9080\u8bf7\u8bbf\u5ba2\u3002",
    "You have not shared any folders": "\u4f60\u8fd8\u6ca1\u6709\u5171\u4eab\u4efb\u4f55\u76ee\u5f55",
    "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.": "\u4f60\u8fd8\u6ca1\u5171\u4eab\u4efb\u4f55\u76ee\u5f55\u7ed9\u5176\u4ed6\u7528\u6237\u3002\u53ef\u4ee5\u901a\u8fc7\u70b9\u51fb\u76ee\u5f55\u540d\u79f0\u65c1\u8fb9\u7684\u5171\u4eab\u56fe\u6807\u6765\u5171\u4eab\u4e00\u4e2a\u76ee\u5f55\u3002",
    "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".": "\u4f60\u8fd8\u6ca1\u5171\u4eab\u4efb\u4f55\u8d44\u6599\u5e93\u7ed9\u5176\u4ed6\u7528\u6237\u3002\u53ef\u4ee5\u5728\u201c\u6211\u7684\u8d44\u6599\u5e93\u201d\u9875\u9762\u901a\u8fc7\u70b9\u51fb\u8d44\u6599\u5e93\u540d\u79f0\u65c1\u8fb9\u7684\u5171\u4eab\u56fe\u6807\u6765\u5171\u4eab\u4e00\u4e2a\u8d44\u6599\u5e93\u3002",
    "You have only one backup code remaining.": "\u4f60\u53ea\u6709\u4e00\u4e2a\u5907\u7528\u9a8c\u8bc1\u7801\u3002",
    "You have {num} backup codes remaining.": "\u4f60\u8fd8\u5269\u4f59 {num} \u4e2a\u5907\u7528\u9a8c\u8bc1\u7801\u3002",
    "Your notifications will be sent to this email.": "\u4f60\u7684\u901a\u77e5\u5c06\u53d1\u9001\u5230\u8be5\u90ae\u7bb1\u3002",
    "ZIP": "ZIP",
    "ZIP Selected Items": "\u6253\u5305\u4e0b\u8f7d\u6240\u9009\u9879",
    "Zoom in": "\u7f29\u5c0f",
    "Zoom out": "\u653e\u5927",
    "all": "\u5168\u90e8",
    "all members": "\u6240\u6709\u6210\u5458",
    "contains": "\u5305\u542b",
    "copy": "\u590d\u5236",
    "days": "\u5929",
    "deleted": "\u5df2\u5220\u9664",
    "deleted option": "\u5220\u9664\u9009\u9879",
    "details": "\u8be6\u60c5",
    "does not contain": "\u4e0d\u5305\u542b",
    "email is required": "\u8bf7\u8f93\u5165\u90ae\u7bb1",
    "freezed": "\u5df2\u51bb\u7ed3",
    "has all of...": "\u5305\u542b\u6240\u6709",
    "has any of...": "\u5305\u542b\u5176\u4e2d\u4e00\u4e2a",
    "has none of...": "\u4e0d\u5305\u542b",
    "icon": "\u56fe\u6807",
    "in all libraries": "\u5728\u5168\u90e8\u8d44\u6599\u5e93\u4e2d",
    "in this folder": "\u5728\u8fd9\u4e2a\u76ee\u5f55",
    "in this library": "\u5728\u8fd9\u4e2a\u8d44\u6599\u5e93\u4e2d",
    "include the current user": "\u5305\u62ec\u5f53\u524d\u7528\u6237",
    "is": "\u662f",
    "is after...": "\u5728\u67d0\u5929\u4e4b\u540e",
    "is any of...": "\u662f\u4efb\u610f\u4e00\u4e2a...",
    "is before...": "\u5728\u67d0\u5929\u4e4b\u524d",
    "is current user's ID": "\u662f\u5f53\u524d\u7528\u6237\u7684 ID",
    "is empty": "\u662f\u7a7a",
    "is exactly...": "\u7cbe\u786e\u7b5b\u9009",
    "is none of...": "\u4e0d\u662f\u4efb\u610f\u4e00\u4e2a...",
    "is not": "\u4e0d\u662f",
    "is not empty": "\u4e0d\u662f\u7a7a",
    "is on or after...": "\u5728\u67d0\u5929\u6216\u4e4b\u540e",
    "is on or before...": "\u5728\u67d0\u5929\u6216\u4e4b\u524d",
    "is within...": "\u5728\u67d0\u6bb5\u65f6\u95f4\u5185",
    "items": "\u4e2a\u9879\u76ee",
    "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}": "\u6388\u6743\u7ed9 {placeholder_license_to}\uff0c{placeholder_license_expiration} \u5230\u671f",
    "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}": "\u6388\u6743\u7ed9 {placeholder_license_to}\uff0c\u5347\u7ea7\u670d\u52a1\u4e8e {placeholder_license_expiration} \u5230\u671f",
    "locked": "\u5df2\u9501\u5b9a",
    "locked by {name}": "\u88ab {name} \u9501\u5b9a",
    "members": "\u6210\u5458",
    "mm": "\u6beb\u7c73",
    "name": "\u540d\u79f0",
    "not set": "\u672a\u8bbe\u7f6e",
    "only show {placeholder}": "\u53ea\u663e\u793a {placeholder}",
    "progress": "\u8fdb\u5ea6",
    "s": "\u79d2",
    "selected": "\u5df2\u9009\u62e9",
    "shared by:": "\u5171\u4eab\u6765\u6e90\uff1a",
    "show more": "\u663e\u793a\u66f4\u591a",
    "size": "\u5927\u5c0f",
    "sorts": "\u4e2a\u6392\u5e8f",
    "starred": "\u5df2\u52a0\u661f\u6807",
    "state": "\u72b6\u6001",
    "successfully added user %s.": "\u6210\u529f\u6dfb\u52a0\u7528\u6237 %s\u3002",
    "successfully sent email to %s.": "\u90ae\u4ef6\u5df2\u6210\u529f\u53d1\u9001\u7ed9 %s\u3002",
    "unstarred": "\u672a\u52a0\u661f\u6807",
    "xxx cells copied": "\u5df2\u590d\u5236 xxx \u5355\u5143\u683c",
    "xxx cells cut": "xxx \u4e2a\u5355\u5143\u683c\u5df2\u526a\u5207",
    "xxx cells selected": "xxx \u5355\u5143\u683c\u5df2\u9009\u4e2d",
    "xxx record": "xxx \u4e2a\u8bb0\u5f55",
    "xxx records": "xxx \u6761\u8bb0\u5f55",
    "xxx records selected": "xxx \u6761\u8bb0\u5f55\u5df2\u9009\u4e2d",
    "xxx rows are copied.": "\u5df2\u590d\u5236 xxx \u884c\u3002",
    "{failed_files_num} file(s) failed to upload": "{failed_files_num} \u4e2a\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25",
    "{file} and {n} other files": "{file} \u53ca {n} \u4e2a\u5176\u4ed6\u6587\u4ef6",
    "{library_name} Office Suite": "{library_name} \u529e\u516c\u5957\u4ef6",
    "{minDays_placeholder} - {maxDays_placeholder} days": "{minDays_placeholder} - {maxDays_placeholder} \u5929",
    "{name_placeholder} cells copied": "\u5df2\u590d\u5236 {name_placeholder} \u4e2a\u5355\u5143\u683c",
    "{name_placeholder} cells cut": "\u5df2\u526a\u5207 {name_placeholder} \u4e2a\u5355\u5143\u683c",
    "{name_placeholder} cells selected": "\u5df2\u9009\u62e9 {name_placeholder} \u4e2a\u5355\u5143\u683c",
    "{name_placeholder} hidden properties": "{name_placeholder} \u4e2a\u9690\u85cf\u5c5e\u6027",
    "{name_placeholder} preset hidden properties": "{name_placeholder} \u9884\u9690\u85cf\u5c5e\u6027",
    "{name_placeholder} record": "{name_placeholder} \u4e2a\u8bb0\u5f55",
    "{name_placeholder} records": "{name_placeholder} \u4e2a\u8bb0\u5f55",
    "{name_placeholder} records selected": "\u5df2\u9009\u62e9 {name_placeholder} \u4e2a\u8bb0\u5f55",
    "{name_placeholder} rows are copied.": "{name_placeholder} \u4e2a\u884c\u88ab\u590d\u5236\u3002",
    "{name} rows use this option.": "{name} \u884c\u4f7f\u7528\u8fd9\u4e2a\u9009\u9879\u3002",
    "{number_placeholder} / Page": "{number_placeholder} / \u9875",
    "{placeholder} API Token": "{placeholder} API Token",
    "{placeholder} Access Log": "{placeholder} \u8bbf\u95ee\u65e5\u5fd7",
    "{placeholder} Folder Permission": "{placeholder} \u76ee\u5f55\u6743\u9650",
    "{placeholder} History Setting": "{placeholder} \u5386\u53f2\u8bbe\u7f6e",
    "{placeholder} Modification History": "{placeholder}\u4fee\u6539\u5386\u53f2\u8bb0\u5f55",
    "{placeholder} Share Admin": "{placeholder} \u5171\u4eab\u7ba1\u7406",
    "{placeholder} Snapshot": "{placeholder} \u955c\u50cf",
    "{placeholder} Trash": "{placeholder} \u56de\u6536\u7ad9",
    "{placeholder} Wiki Trash": "{placeholder} \u77e5\u8bc6\u5e93\u56de\u6536\u7ad9",
    "{share_from} has cancelled the sharing of folder {repo_name}.": "{share_from} \u5df2\u7ecf\u53d6\u6d88\u4e86\u76ee\u5f55 {repo_name} \u7684\u5171\u4eab\u3002",
    "{share_from} has cancelled the sharing of library {repo_name}.": "{share_from} \u5df2\u7ecf\u53d6\u6d88\u4e86\u8d44\u6599\u5e93 {repo_name} \u7684\u5171\u4eab\u3002",
    "{share_from} has changed the permission of folder {repo_link} to {permission}.": "{share_from} \u5df2\u7ecf\u5c06\u76ee\u5f55 {repo_link} \u7684\u6743\u9650\u6539\u4e3a {permission}\u3002",
    "{share_from} has changed the permission of library {repo_link} to {permission}.": "{share_from} \u5df2\u7ecf\u5c06\u8d44\u6599\u5e93 {repo_link} \u7684\u6743\u9650\u6539\u4e3a {permission}\u3002",
    "{share_from} has shared a folder named {repo_link} to group {group_link}.": "{share_from} \u7ed9\u7fa4\u7ec4 {group_link} \u5171\u4eab\u4e86\u4e00\u4e2a\u76ee\u5f55 {repo_link} \u3002",
    "{share_from} has shared a folder named {repo_link} to you.": "{share_from} \u7ed9\u4f60\u5171\u4eab\u4e86\u4e00\u4e2a\u540d\u4e3a {repo_link} \u7684\u76ee\u5f55\u3002",
    "{share_from} has shared a library named {repo_link} to group {group_link}.": "{share_from} \u7ed9\u7fa4\u7ec4 {group_link} \u5171\u4eab\u4e86\u4e00\u4e2a\u8d44\u6599\u5e93 {repo_link}\u3002",
    "{share_from} has shared a library named {repo_link} to you.": "{share_from} \u5171\u4eab\u4e86\u8d44\u6599\u5e93 {repo_link} \u7ed9\u4f60\u3002",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. However, since you are a guest user now, you can not create libraries.": " {site_name_placeholder} \u901a\u8fc7\u8d44\u6599\u5e93\u6765\u7ba1\u7406\u6587\u4ef6\u3002\u6bcf\u4e2a\u8d44\u6599\u5e93\u53ef\u4ee5\u5355\u72ec\u52a0\u5bc6\u548c\u5171\u4eab\u3002\u7136\u800c\uff0c\u56e0\u4e3a\u4f60\u73b0\u5728\u662f\u8bbf\u5ba2\uff0c\u6240\u4ee5\u4e0d\u80fd\u521b\u5efa\u8d44\u6599\u5e93\u3002",
    "{site_name_placeholder} organizes files into libraries. Each library can be synced and shared separately. We have created a personal library for you. You can create more libraries later.": "{site_name_placeholder} \u628a\u6587\u4ef6\u7ec4\u7ec7\u5230\u8d44\u6599\u5e93\u91cc\u3002\u6bcf\u4e2a\u8d44\u6599\u5e93\u53ef\u4ee5\u88ab\u5355\u72ec\u5730\u540c\u6b65\u548c\u5171\u4eab\u3002\u6211\u4eec\u5df2\u7ecf\u4e3a\u4f60\u521b\u5efa\u4e86\u4e00\u4e2a\u79c1\u4eba\u8d44\u6599\u5e93\u3002\u4e4b\u540e\u4f60\u53ef\u4ee5\u521b\u5efa\u66f4\u591a\u7684\u8d44\u6599\u5e93\u3002",
    "{uploaded_files_num}/{all_files_num} Files": "{uploaded_files_num}/{all_files_num} \u4e2a",
    "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.": "\u8be5\u56e2\u961f\u4e2d\u7684 {userCount} \u4e2a\u7528\u6237\u548c {repoCount} \u4e2a\u8d44\u6599\u5e93\u4e5f\u5c06\u88ab\u5220\u9664\u3002",
    "{user} created file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} \u5728\u8d44\u6599\u5e93 {libraryName} \u4e2d\u521b\u5efa\u4e86\u6587\u4ef6 {fileName} \u548c {fileCount} \u4e2a\u5176\u4ed6\u6587\u4ef6\u3002",
    "{user} created file {fileName} in library {libraryName}.": "{user} \u5728\u8d44\u6599\u5e93 {libraryName} \u4e2d\u521b\u5efa\u4e86\u6587\u4ef6 {fileName}\u3002",
    "{user} created folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} \u5728\u8d44\u6599\u5e93 {libraryName} \u4e2d\u521b\u5efa\u4e86\u76ee\u5f55 {folderName} \u548c {folderCount} \u4e2a\u5176\u4ed6\u76ee\u5f55\u3002",
    "{user} created folder {folderName} in library {libraryName}.": "{user} \u5728\u8d44\u6599\u5e93 {libraryName} \u4e2d\u521b\u5efa\u4e86\u76ee\u5f55 {folderName}\u3002",
    "{user} deleted file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} \u5728\u8d44\u6599\u5e93 {libraryName} \u4e2d\u5220\u9664\u4e86\u6587\u4ef6 {fileName} \u548c {fileCount} \u4e2a\u5176\u4ed6\u6587\u4ef6\u3002",
    "{user} deleted file {fileName} in library {libraryName}.": "{user} \u5728\u8d44\u6599\u5e93 {libraryName} \u4e2d\u5220\u9664\u4e86\u6587\u4ef6 {fileName}\u3002",
    "{user} deleted folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} \u5728\u8d44\u6599\u5e93 {libraryName} \u4e2d\u5220\u9664\u4e86\u76ee\u5f55 {folderName} \u548c {folderCount} \u4e2a\u5176\u4ed6\u76ee\u5f55\u3002",
    "{user} deleted folder {folderName} in library {libraryName}.": "{user} \u5728\u8d44\u6599\u5e93 {libraryName} \u4e2d\u5220\u9664\u4e86\u76ee\u5f55 {folderName}\u3002",
    "{user} has transfered a library named {repo_link} to you.": "{user} \u8f6c\u8ba9\u4e86\u4e00\u4e2a\u8d44\u6599\u5e93 {repo_link} \u7ed9\u4f60\u3002",
    "{user} moved file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} \u5728\u8d44\u6599\u5e93 {libraryName} \u4e2d\u79fb\u52a8\u4e86\u6587\u4ef6 {fileName} \u548c {fileCount} \u4e2a\u5176\u4ed6\u6587\u4ef6\u3002",
    "{user} moved file {fileName} in library {libraryName}.": "{user} \u79fb\u52a8\u4e86\u8d44\u6599\u5e93 {libraryName} \u4e2d\u7684\u6587\u4ef6 {fileName}\u3002",
    "{user} moved folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} \u79fb\u52a8\u4e86\u8d44\u6599\u5e93 {libraryName} \u4e2d\u7684\u76ee\u5f55 {folderName} \u548c {folderCount} \u4e2a\u5176\u4ed6\u76ee\u5f55\u3002",
    "{user} moved folder {folderName} in library {libraryName}.": "{user} \u79fb\u52a8\u4e86\u8d44\u6599\u5e93 {libraryName} \u4e2d\u7684\u76ee\u5f55 {folderName}\u3002",
    "{user} renamed file {oldFileName} {fileName} in library {libraryName}.": "{user} \u5728\u8d44\u6599\u5e93 {libraryName} \u4e2d\u5c06\u6587\u4ef6 {oldFileName} \u91cd\u547d\u540d\u4e3a {fileName}\u3002",
    "{user} renamed folder {oldFolderName} {folderName} in library {libraryName}.": "{user} \u5728\u8d44\u6599\u5e93 {libraryName} \u4e2d\u5c06\u76ee\u5f55 {oldFolderName} \u91cd\u547d\u540d\u4e3a {folderName}\u3002",
    "{user} restored file {fileName} in library {libraryName}.": "{user} \u5728\u8d44\u6599\u5e93 {libraryName} \u4e2d\u6062\u590d\u4e86\u6587\u4ef6 {fileName}\u3002",
    "{user} restored folder {folderName} in library {libraryName}.": "{user} \u5728\u8d44\u6599\u5e93 {libraryName} \u4e2d\u6062\u590d\u4e86\u76ee\u5f55 {folderName}\u3002",
    "{user} updated file {fileName} in library {libraryName}.": "{user} \u5728\u8d44\u6599\u5e93 {libraryName} \u4e2d\u66f4\u65b0\u4e86\u6587\u4ef6 {fileName}\u3002"
  };
  for (const key in newcatalog) {
    django.catalog[key] = newcatalog[key];
  }
  

  if (!django.jsi18n_initialized) {
    django.gettext = function(msgid) {
      const value = django.catalog[msgid];
      if (typeof value === 'undefined') {
        return msgid;
      } else {
        return (typeof value === 'string') ? value : value[0];
      }
    };

    django.ngettext = function(singular, plural, count) {
      const value = django.catalog[singular];
      if (typeof value === 'undefined') {
        return (count == 1) ? singular : plural;
      } else {
        return value.constructor === Array ? value[django.pluralidx(count)] : value;
      }
    };

    django.gettext_noop = function(msgid) { return msgid; };

    django.pgettext = function(context, msgid) {
      let value = django.gettext(context + '\x04' + msgid);
      if (value.includes('\x04')) {
        value = msgid;
      }
      return value;
    };

    django.npgettext = function(context, singular, plural, count) {
      let value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
      if (value.includes('\x04')) {
        value = django.ngettext(singular, plural, count);
      }
      return value;
    };

    django.interpolate = function(fmt, obj, named) {
      if (named) {
        return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
      } else {
        return fmt.replace(/%s/g, function(match){return String(obj.shift())});
      }
    };


    /* formatting library */

    django.formats = {
    "DATETIME_FORMAT": "N j, Y, P",
    "DATETIME_INPUT_FORMATS": [
      "%Y-%m-%d %H:%M:%S",
      "%Y-%m-%d %H:%M:%S.%f",
      "%Y-%m-%d %H:%M",
      "%m/%d/%Y %H:%M:%S",
      "%m/%d/%Y %H:%M:%S.%f",
      "%m/%d/%Y %H:%M",
      "%m/%d/%y %H:%M:%S",
      "%m/%d/%y %H:%M:%S.%f",
      "%m/%d/%y %H:%M"
    ],
    "DATE_FORMAT": "N j, Y",
    "DATE_INPUT_FORMATS": [
      "%Y-%m-%d",
      "%m/%d/%Y",
      "%m/%d/%y",
      "%b %d %Y",
      "%b %d, %Y",
      "%d %b %Y",
      "%d %b, %Y",
      "%B %d %Y",
      "%B %d, %Y",
      "%d %B %Y",
      "%d %B, %Y"
    ],
    "DECIMAL_SEPARATOR": ".",
    "FIRST_DAY_OF_WEEK": 0,
    "MONTH_DAY_FORMAT": "F j",
    "NUMBER_GROUPING": 0,
    "SHORT_DATETIME_FORMAT": "m/d/Y P",
    "SHORT_DATE_FORMAT": "m/d/Y",
    "THOUSAND_SEPARATOR": ",",
    "TIME_FORMAT": "P",
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S",
      "%H:%M:%S.%f",
      "%H:%M"
    ],
    "YEAR_MONTH_FORMAT": "F Y"
  };

    django.get_format = function(format_type) {
      const value = django.formats[format_type];
      if (typeof value === 'undefined') {
        return format_type;
      } else {
        return value;
      }
    };

    /* add to global namespace */
    globals.pluralidx = django.pluralidx;
    globals.gettext = django.gettext;
    globals.ngettext = django.ngettext;
    globals.gettext_noop = django.gettext_noop;
    globals.pgettext = django.pgettext;
    globals.npgettext = django.npgettext;
    globals.interpolate = django.interpolate;
    globals.get_format = django.get_format;

    django.jsi18n_initialized = true;
  }
};

